/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.domain.ExecChannel;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="JschSshClientLiveTest")
public class JschSshClientLiveTest {
    protected static final String sshHost = System.getProperty("test.ssh.host", "localhost");
    protected static final String sshPort = System.getProperty("test.ssh.port", "22");
    protected static final String sshUser = System.getProperty("test.ssh.username");
    protected static final String sshPass = System.getProperty("test.ssh.password");
    protected static final String sshKeyFile = System.getProperty("test.ssh.keyfile");
    private File temp;

    @BeforeGroups(groups={"live"})
    public SshClient setupClient() throws NumberFormatException, FileNotFoundException, IOException {
        int port = Integer.parseInt(sshPort);
        if (sshUser == null || (sshPass == null || sshPass.trim().equals("")) && (sshKeyFile == null || sshKeyFile.trim().equals("")) || sshUser.trim().equals("")) {
            System.err.println("ssh credentials not present.  Tests will be lame");
            return new SshClient(){

                public void connect() {
                }

                public void disconnect() {
                }

                public Payload get(String path) {
                    if (path.equals("/etc/passwd")) {
                        return Payloads.newStringPayload((String)"root");
                    }
                    if (path.equals(JschSshClientLiveTest.this.temp.getAbsolutePath())) {
                        return Payloads.newStringPayload((String)"rabbit");
                    }
                    throw new RuntimeException("path " + path + " not stubbed");
                }

                public ExecResponse exec(String command) {
                    if (command.equals("hostname")) {
                        return new ExecResponse(sshHost, "", 0);
                    }
                    throw new RuntimeException("command " + command + " not stubbed");
                }

                public void put(String path, Payload contents) {
                }

                public String getHostAddress() {
                    return null;
                }

                public String getUsername() {
                    return null;
                }

                public void put(String path, String contents) {
                }

                public ExecChannel execChannel(String command) {
                    if (command.equals("hostname")) {
                        return new ExecChannel((OutputStream)new ByteArrayOutputStream(), (InputStream)new ByteArrayInputStream(sshHost.getBytes()), (InputStream)new ByteArrayInputStream(new byte[0]), Suppliers.ofInstance((Object)0), new Closeable(){

                            @Override
                            public void close() {
                            }
                        });
                    }
                    throw new RuntimeException("command " + command + " not stubbed");
                }
            };
        }
        Injector i = Guice.createInjector((Module[])new Module[]{new JschSshClientModule(), new SLF4JLoggingModule()});
        SshClient.Factory factory = (SshClient.Factory)i.getInstance(SshClient.Factory.class);
        SshClient connection = Strings.emptyToNull((String)sshKeyFile) != null ? factory.create(HostAndPort.fromParts((String)sshHost, (int)port), LoginCredentials.builder().user(sshUser).privateKey(Files.toString((File)new File(sshKeyFile), (Charset)Charsets.UTF_8)).build()) : factory.create(HostAndPort.fromParts((String)sshHost, (int)port), LoginCredentials.builder().user(sshUser).password(sshPass).build());
        connection.connect();
        return connection;
    }

    @Test
    public void testPutAndGet() throws IOException {
        this.temp = File.createTempFile("foo", "bar");
        this.temp.deleteOnExit();
        SshClient client = this.setupClient();
        client.put(this.temp.getAbsolutePath(), (Payload)Payloads.newStringPayload((String)"rabbit"));
        Payload input = this.setupClient().get(this.temp.getAbsolutePath());
        String contents = Strings2.toString((InputSupplier)input);
        Assert.assertEquals((String)contents, (String)"rabbit");
    }

    @Test
    public void testGetEtcPassword() throws IOException {
        Payload input = this.setupClient().get("/etc/passwd");
        String contents = Strings2.toString((InputSupplier)input);
        assert (contents.indexOf("root") >= 0) : "no root in " + contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecHostname() throws IOException {
        SshClient client = this.setupClient();
        try {
            ExecResponse response = client.exec("hostname");
            Assert.assertEquals((int)response.getExitStatus(), (int)0);
            Assert.assertEquals((String)response.getError(), (String)"");
            Assert.assertEquals((String)response.getOutput().trim(), (String)("localhost".equals(sshHost) ? InetAddress.getLocalHost().getHostName() : sshHost));
        }
        finally {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecInvalidCommand() throws IOException {
        SshClient client = this.setupClient();
        try {
            ExecResponse response = client.exec("thisCommandDoesNotExist");
            Assert.assertNotEquals((Object)response.getExitStatus(), (Object)0);
            Assert.assertTrue((response.getOutput().contains("not found") || response.getError().contains("not found") ? 1 : 0) != 0, (String)("stdout=" + response.getOutput() + "; stderr=" + response.getError()));
        }
        finally {
            client.disconnect();
        }
    }

    @Test(invocationCount=100)
    public void testExecHostnameRepeatedlyWithDifferentSessions() throws Exception {
        this.testExecHostname();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecHostnameRepeatedlyWithSameSessions() throws Exception {
        SshClient client = this.setupClient();
        try {
            for (int i = 0; i < 100; ++i) {
                ExecResponse response = client.exec("hostname");
                Assert.assertEquals((String)response.getError(), (String)"");
                Assert.assertEquals((String)response.getOutput().trim(), (String)("localhost".equals(sshHost) ? InetAddress.getLocalHost().getHostName() : sshHost));
            }
        }
        finally {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecHostnameConcurrentlyWithSameSessions() throws Exception {
        final SshClient client = this.setupClient();
        ListeningExecutorService userExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
        ArrayList futures = Lists.newArrayList();
        try {
            for (int i = 0; i < 100; ++i) {
                futures.add(userExecutor.submit((Callable)new Callable<ExecResponse>(){

                    @Override
                    public ExecResponse call() {
                        ExecResponse response = client.exec("hostname");
                        return response;
                    }
                }));
            }
            List responses = (List)Futures.allAsList((Iterable)futures).get(3000L, TimeUnit.SECONDS);
            for (ExecResponse response : responses) {
                Assert.assertEquals((String)response.getError(), (String)"");
                Assert.assertEquals((String)response.getOutput().trim(), (String)("localhost".equals(sshHost) ? InetAddress.getLocalHost().getHostName() : sshHost));
            }
        }
        finally {
            userExecutor.shutdownNow();
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecChannelTakesStdinAndNoEchoOfCharsInOuputAndOutlivesClient() throws IOException {
        SshClient client = this.setupClient();
        ExecChannel response = client.execChannel("cat <<EOF");
        client.disconnect();
        Assert.assertEquals((Object)response.getExitStatus().get(), null);
        try {
            PrintStream printStream = new PrintStream(response.getInput());
            printStream.append("foo\n");
            printStream.append("EOF\n");
            printStream.close();
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)response.getError()), (String)"");
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)response.getOutput()), (String)"");
        }
        finally {
            Closeables.closeQuietly((Closeable)response);
        }
        Assert.assertEquals((Object)response.getExitStatus().get(), (Object)0);
    }
}

