/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import java.util.Properties;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.proxy.ProxyConfig;
import org.jclouds.ssh.jsch.JschSshClient;

public final class SessionConnection
implements JschSshClient.Connection<Session> {
    private static final byte[] emptyPassPhrase = new byte[0];
    private final HostAndPort hostAndPort;
    private final LoginCredentials loginCredentials;
    private final Optional<Proxy> proxy;
    private final int connectTimeout;
    private final int sessionTimeout;
    private transient Session session;

    public static Builder builder() {
        return new Builder();
    }

    private SessionConnection(HostAndPort hostAndPort, LoginCredentials loginCredentials, Optional<Proxy> proxy, int connectTimeout, int sessionTimeout) {
        this.hostAndPort = (HostAndPort)Preconditions.checkNotNull((Object)hostAndPort, (Object)"hostAndPort");
        this.loginCredentials = (LoginCredentials)Preconditions.checkNotNull((Object)loginCredentials, (String)"loginCredentials for %", (Object[])new Object[]{hostAndPort});
        this.connectTimeout = connectTimeout;
        this.sessionTimeout = sessionTimeout;
        this.proxy = (Optional)Preconditions.checkNotNull(proxy, (String)"proxy for %", (Object[])new Object[]{hostAndPort});
    }

    @Override
    public void clear() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            this.session = null;
        }
    }

    @Override
    public Session create() throws Exception {
        JSch jsch = new JSch();
        this.session = jsch.getSession(this.loginCredentials.getUser(), this.hostAndPort.getHostText(), this.hostAndPort.getPortOrDefault(22));
        if (this.sessionTimeout != 0) {
            this.session.setTimeout(this.sessionTimeout);
        }
        if (this.loginCredentials.getPrivateKey() == null) {
            this.session.setPassword(this.loginCredentials.getPassword());
        } else {
            Preconditions.checkArgument((!this.loginCredentials.getPrivateKey().contains("Proc-Type: 4,ENCRYPTED") ? 1 : 0) != 0, (Object)"JschSshClientModule does not support private keys that require a passphrase");
            byte[] privateKey = this.loginCredentials.getPrivateKey().getBytes();
            jsch.addIdentity(this.loginCredentials.getUser(), privateKey, null, emptyPassPhrase);
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        if (this.proxy.isPresent()) {
            this.session.setProxy((Proxy)this.proxy.get());
        }
        this.session.connect(this.connectTimeout);
        return this.session;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public LoginCredentials getLoginCredentials() {
        return this.loginCredentials;
    }

    public Optional<Proxy> getProxy() {
        return this.proxy;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Nullable
    public Session getSession() {
        return this.session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConnection that = (SessionConnection)SessionConnection.class.cast(o);
        return Objects.equal((Object)this.hostAndPort, (Object)that.hostAndPort) && Objects.equal((Object)this.loginCredentials, (Object)that.loginCredentials) && Objects.equal((Object)this.session, (Object)that.session);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostAndPort, this.loginCredentials, this.session});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").omitNullValues().add("hostAndPort", (Object)this.hostAndPort).add("loginUser", (Object)this.loginCredentials.getUser()).add("session", this.session != null ? Integer.valueOf(this.session.hashCode()) : null).add("connectTimeout", this.connectTimeout).add("proxy", this.proxy.orNull()).add("sessionTimeout", this.sessionTimeout).toString();
    }

    public static final class Builder {
        private HostAndPort hostAndPort;
        private LoginCredentials loginCredentials;
        private Optional<Proxy> proxy = Optional.absent();
        private int connectTimeout;
        private int sessionTimeout;

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Builder loginCredentials(LoginCredentials loginCredentials) {
            this.loginCredentials = loginCredentials;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = Optional.fromNullable((Object)proxy);
            return this;
        }

        public Builder proxy(ProxyConfig proxyConfig) {
            Optional proxyEndpoint = proxyConfig.getProxy();
            if (!proxyEndpoint.isPresent()) {
                return this.proxy((Proxy)null);
            }
            Optional creds = proxyConfig.getCredentials();
            switch (proxyConfig.getType()) {
                case HTTP: {
                    ProxyHTTP httpProxy = new ProxyHTTP(((HostAndPort)proxyEndpoint.get()).getHostText(), ((HostAndPort)proxyEndpoint.get()).getPort());
                    if (creds.isPresent()) {
                        httpProxy.setUserPasswd(((Credentials)creds.get()).identity, ((Credentials)creds.get()).credential);
                    }
                    return this.proxy((Proxy)httpProxy);
                }
                case SOCKS: {
                    ProxySOCKS5 socksProxy = new ProxySOCKS5(((HostAndPort)proxyEndpoint.get()).getHostText(), ((HostAndPort)proxyEndpoint.get()).getPort());
                    if (creds.isPresent()) {
                        socksProxy.setUserPasswd(((Credentials)creds.get()).identity, ((Credentials)creds.get()).credential);
                    }
                    return this.proxy((Proxy)socksProxy);
                }
            }
            throw new IllegalArgumentException((Object)((Object)proxyConfig.getType()) + " not supported");
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder sessionTimeout(int sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public SessionConnection build() {
            return new SessionConnection(this.hostAndPort, this.loginCredentials, this.proxy, this.connectTimeout, this.sessionTimeout);
        }

        public Builder from(SessionConnection in) {
            return this.hostAndPort(in.hostAndPort).loginCredentials(in.loginCredentials).proxy((Proxy)in.proxy.orNull()).connectTimeout(in.connectTimeout).sessionTimeout(in.sessionTimeout);
        }
    }
}

