/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import java.net.URI;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="StatementsTest")
public class StatementsTest {
    public void testSaveHttpResponseToUNIX() {
        Statement save = Statements.saveHttpResponseTo((URI)URI.create("https://s3.amazonaws.com/MinecraftDownload/launcher/minecraft_server.jar"), (String)"/opt/minecraft", (String)"minecraft_server.jar");
        Assert.assertEquals((String)save.render(OsFamily.UNIX), (String)"(mkdir -p /opt/minecraft && cd /opt/minecraft && [ ! -f minecraft_server.jar ] && curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -C - -X GET  https://s3.amazonaws.com/MinecraftDownload/launcher/minecraft_server.jar >minecraft_server.jar)\n");
    }

    public void testExtractTargzIntoDirectoryUNIX() {
        Statement save = Statements.extractTargzIntoDirectory((URI)URI.create("https://s3.amazonaws.com/MinecraftDownload/launcher/minecraft_server.tar.gz"), (String)"/opt/minecraft");
        Assert.assertEquals((String)save.render(OsFamily.UNIX), (String)"curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET  https://s3.amazonaws.com/MinecraftDownload/launcher/minecraft_server.tar.gz |(mkdir -p /opt/minecraft &&cd /opt/minecraft &&tar -xpzf -)\n");
    }

    public void testExtractTargzAndFlattenIntoDirectoryUNIX() {
        Statement save = Statements.extractTargzAndFlattenIntoDirectory((URI)URI.create("http://www.us.apache.org/dist/maven/binaries/apache-maven-3.0.4-bin.tar.gz"), (String)"/usr/local/maven");
        Assert.assertEquals((String)save.render(OsFamily.UNIX), (String)"mkdir /tmp/$$\ncurl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20 -X GET  http://www.us.apache.org/dist/maven/binaries/apache-maven-3.0.4-bin.tar.gz |(mkdir -p /tmp/$$ &&cd /tmp/$$ &&tar -xpzf -)\nmkdir -p /usr/local/maven\nmv /tmp/$$/*/* /usr/local/maven\nrm -rf /tmp/$$\n");
    }
}

