/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Function;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.login.ReplaceShadowPasswordEntry;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ReplaceShadowPasswordEntryTest {
    Function<String, String> crypt = new Function<String, String>(){

        public String apply(String in) {
            Assert.assertEquals((String)in, (String)"password");
            return "CRYPT";
        }
    };

    public void testWithPasswordUNIX() {
        String userAdd = new ReplaceShadowPasswordEntry(this.crypt, "foo", "password").render(OsFamily.UNIX);
        assert (userAdd.startsWith("awk -v user=^foo: -v password='CRYPT")) : userAdd;
        assert (userAdd.endsWith("' 'BEGIN { FS=OFS=\":\" } $0 ~ user { $2 = password } 1' /etc/shadow >/etc/shadow.foo\ntest -f /etc/shadow.foo && mv /etc/shadow.foo /etc/shadow\n")) : userAdd;
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddUserWindowsNotSupported() {
        new ReplaceShadowPasswordEntry(this.crypt, "user", "password").render(OsFamily.WINDOWS);
    }
}

