/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ssh;

import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.statements.ssh.InstallRSAPrivateKey;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InstallRSAPrivateKeyTest {
    public void testInstallRSAPrivateKeyUNIXCurrentUser() {
        Assert.assertEquals((String)new InstallRSAPrivateKey("-----BEGIN RSA PRIVATE KEY-----\n-----END RSA PRIVATE KEY-----\n").render(OsFamily.UNIX), (String)"mkdir -p ~/.ssh\nrm ~/.ssh/id_rsa\ncat >> ~/.ssh/id_rsa <<-'END_OF_JCLOUDS_FILE'\n\t-----BEGIN RSA PRIVATE KEY-----\n\t-----END RSA PRIVATE KEY-----\n\t\nEND_OF_JCLOUDS_FILE\nchmod 600 ~/.ssh/id_rsa\n");
    }

    public void testInstallRSAPrivateKeyUNIXSpecifiedHome() {
        Assert.assertEquals((String)new InstallRSAPrivateKey("/home/me/.ssh", "-----BEGIN RSA PRIVATE KEY-----\n-----END RSA PRIVATE KEY-----\n").render(OsFamily.UNIX), (String)"mkdir -p /home/me/.ssh\nrm /home/me/.ssh/id_rsa\ncat >> /home/me/.ssh/id_rsa <<-'END_OF_JCLOUDS_FILE'\n\t-----BEGIN RSA PRIVATE KEY-----\n\t-----END RSA PRIVATE KEY-----\n\t\nEND_OF_JCLOUDS_FILE\nchmod 600 /home/me/.ssh/id_rsa\n");
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testInstallRSAPrivateKeyWINDOWS() {
        new InstallRSAPrivateKey("-----BEGIN RSA PRIVATE KEY-----\n-----END RSA PRIVATE KEY-----\n").render(OsFamily.WINDOWS);
    }
}

