/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.jclouds.scriptbuilder.EnvBuilder;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnvBuilderTest {
    EnvBuilder testScriptBuilder = new EnvBuilder().export("JAVA_HOME", "/apps/jdk1.6");

    @Test
    public void testBuildSimpleWindows() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testScriptBuilder.build(OsFamily.WINDOWS), (String)Resources.toString((URL)Resources.getResource((String)("test_env." + ShellToken.SH.to(OsFamily.WINDOWS))), (Charset)Charsets.UTF_8));
    }

    @Test
    public void testBuildSimpleUNIX() throws MalformedURLException, IOException {
        Assert.assertEquals((String)this.testScriptBuilder.build(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_env." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }

    @Test
    public void testExport() {
        EnvBuilder builder = new EnvBuilder();
        builder.export("JAVA_HOME", "/apps/jdk1.6");
        Assert.assertEquals((Map)builder.variables, (Map)ImmutableMap.of((Object)"JAVA_HOME", (Object)"/apps/jdk1.6"));
    }

    @Test
    public void testNoExport() {
        EnvBuilder builder = new EnvBuilder();
        Assert.assertEquals((int)builder.variables.size(), (int)0);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testExportNPE() {
        new EnvBuilder().export(null, null);
    }
}

