/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.chef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.domain.chef.DataBag;
import org.jclouds.scriptbuilder.domain.chef.Role;
import org.jclouds.scriptbuilder.domain.chef.RunList;
import org.jclouds.scriptbuilder.statements.chef.ChefSolo;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ChefSoloTest")
public class ChefSoloTest {
    public void testCreateDefaultSoloConfiguration() {
        ImmutableList.Builder statements = ImmutableList.builder();
        ChefSolo solo = ChefSolo.builder().build();
        solo.createSoloConfiguration(statements);
        ImmutableList statementList = statements.build();
        Assert.assertEquals((int)statementList.size(), (int)3);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /var/chef"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)"{md} /var/chef/cookbooks"));
        Statement expected = Statements.createOrOverwriteFile((String)"/var/chef/solo.rb", (Iterable)ImmutableSet.of((Object)"file_cache_path \"/var/chef\"", (Object)"cookbook_path [\"/var/chef/cookbooks\"]", (Object)"role_path \"/var/chef/roles\"", (Object)"data_bag_path \"/var/chef/data_bags\""));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateCustomSoloConfiguration() {
        ImmutableList.Builder statements = ImmutableList.builder();
        ChefSolo solo = ChefSolo.builder().fileCachePath("/tmp").cookbookPath("/tmp/foo").cookbookPath("/tmp/bar").rolePath("/tmp/roles").dataBagPath("/tmp/databags").build();
        solo.createSoloConfiguration(statements);
        ImmutableList statementList = statements.build();
        Assert.assertEquals((int)statementList.size(), (int)4);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)"{md} /tmp/foo"));
        Assert.assertEquals((Object)statementList.get(2), (Object)Statements.exec((String)"{md} /tmp/bar"));
        Statement expected = Statements.createOrOverwriteFile((String)"/tmp/solo.rb", (Iterable)ImmutableSet.of((Object)"file_cache_path \"/tmp\"", (Object)"cookbook_path [\"/tmp/foo\",\"/tmp/bar\"]", (Object)"role_path \"/tmp/roles\"", (Object)"data_bag_path \"/tmp/databags\""));
        Assert.assertEquals((String)((Statement)statementList.get(3)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateDefaultNodeConfiguration() {
        ImmutableList.Builder statements = ImmutableList.builder();
        ChefSolo solo = ChefSolo.builder().build();
        solo.createNodeConfiguration(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)"/var/chef/node.json", (Iterable)ImmutableSet.of((Object)"{\"run_list\":[]}"));
        Assert.assertEquals((int)statementList.size(), (int)1);
        Assert.assertEquals((String)((Statement)statementList.get(0)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateNodeConfigurationWithJsonAttributes() {
        ImmutableList.Builder statements = ImmutableList.builder();
        ChefSolo solo = ChefSolo.builder().jsonAttributes("{\"foo\":\"bar\"}").build();
        solo.createNodeConfiguration(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)"/var/chef/node.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\",\"run_list\":[]}"));
        Assert.assertEquals((int)statementList.size(), (int)1);
        Assert.assertEquals((String)((Statement)statementList.get(0)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateNodeConfigurationWithRunList() {
        ImmutableList.Builder statements = ImmutableList.builder();
        RunList runlist = RunList.builder().recipe("foo").role("bar").build();
        ChefSolo solo = ChefSolo.builder().runlist(runlist).build();
        solo.createNodeConfiguration(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)"/var/chef/node.json", (Iterable)ImmutableSet.of((Object)"{\"run_list\":[\"recipe[foo]\",\"role[bar]\"]}"));
        Assert.assertEquals((int)statementList.size(), (int)1);
        Assert.assertEquals((String)((Statement)statementList.get(0)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateNodeConfigurationWithJsonAttributesAndRunList() {
        ImmutableList.Builder statements = ImmutableList.builder();
        RunList runlist = RunList.builder().recipe("foo").role("bar").build();
        ChefSolo solo = ChefSolo.builder().jsonAttributes("{\"foo\":\"bar\"}").runlist(runlist).build();
        solo.createNodeConfiguration(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)"/var/chef/node.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\",\"run_list\":[\"recipe[foo]\",\"role[bar]\"]}"));
        Assert.assertEquals((int)statementList.size(), (int)1);
        Assert.assertEquals((String)((Statement)statementList.get(0)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateRolesIfNecessaryWithDefaultValues() {
        ImmutableList.Builder statements = ImmutableList.builder();
        ChefSolo solo = ChefSolo.builder().build();
        solo.createRolesIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Assert.assertTrue((boolean)statementList.isEmpty());
    }

    public void testCreateRolesIfNecessaryWithOneRole() {
        ImmutableList.Builder statements = ImmutableList.builder();
        RunList runlist = RunList.builder().recipe("bar").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        ChefSolo solo = ChefSolo.builder().defineRole(role).build();
        solo.createRolesIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)("/var/chef/roles/" + role.getName() + ".json"), (Iterable)ImmutableSet.of((Object)role.toJsonString()));
        Assert.assertEquals((int)statementList.size(), (int)2);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /var/chef/roles"));
        Assert.assertEquals((String)((Statement)statementList.get(1)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateRolesIfNecessaryWithOneRoleAndCustomPath() {
        ImmutableList.Builder statements = ImmutableList.builder();
        RunList runlist = RunList.builder().recipe("bar").build();
        Role role = Role.builder().name("foo").runlist(runlist).build();
        ChefSolo solo = ChefSolo.builder().rolePath("/tmp/roles").defineRole(role).build();
        solo.createRolesIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)("/tmp/roles/" + role.getName() + ".json"), (Iterable)ImmutableSet.of((Object)role.toJsonString()));
        Assert.assertEquals((int)statementList.size(), (int)2);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp/roles"));
        Assert.assertEquals((String)((Statement)statementList.get(1)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateRolesIfNecessaryWithMultipleRoleAndCustomPath() {
        ImmutableList.Builder statements = ImmutableList.builder();
        Role roleFoo = Role.builder().name("foo").runlist(RunList.builder().recipe("foo").build()).build();
        Role roleBar = Role.builder().name("bar").runlist(RunList.builder().recipe("bar").build()).build();
        ChefSolo solo = ChefSolo.builder().rolePath("/tmp/roles").defineRole(roleFoo).defineRole(roleBar).build();
        solo.createRolesIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expectedFoo = Statements.createOrOverwriteFile((String)("/tmp/roles/" + roleFoo.getName() + ".json"), (Iterable)ImmutableSet.of((Object)roleFoo.toJsonString()));
        Statement expectedBar = Statements.createOrOverwriteFile((String)("/tmp/roles/" + roleBar.getName() + ".json"), (Iterable)ImmutableSet.of((Object)roleBar.toJsonString()));
        Assert.assertEquals((int)statementList.size(), (int)3);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp/roles"));
        Assert.assertEquals((String)((Statement)statementList.get(1)).render(OsFamily.UNIX), (String)expectedFoo.render(OsFamily.UNIX));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expectedBar.render(OsFamily.UNIX));
    }

    public void testCreateDatabagsIfNecessaryWithDefaultValues() {
        ImmutableList.Builder statements = ImmutableList.builder();
        ChefSolo solo = ChefSolo.builder().build();
        solo.createDatabagsIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Assert.assertTrue((boolean)statementList.isEmpty());
    }

    public void testCreateDatabagsIfNecessaryWithOneDatabag() {
        ImmutableList.Builder statements = ImmutableList.builder();
        DataBag databag = DataBag.builder().name("foo").item("item", "{\"foo\":\"bar\"}").build();
        ChefSolo solo = ChefSolo.builder().defineDataBag(databag).build();
        solo.createDatabagsIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)"/var/chef/data_bags/foo/item.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\"}"));
        Assert.assertEquals((int)statementList.size(), (int)3);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /var/chef/data_bags"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)("{md} /var/chef/data_bags/" + databag.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateDatabagsIfNecessaryWithOneDatabagAndCustomPath() {
        ImmutableList.Builder statements = ImmutableList.builder();
        DataBag databag = DataBag.builder().name("foo").item("item", "{\"foo\":\"bar\"}").build();
        ChefSolo solo = ChefSolo.builder().dataBagPath("/tmp/databags").defineDataBag(databag).build();
        solo.createDatabagsIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expected = Statements.createOrOverwriteFile((String)"/tmp/databags/foo/item.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\"}"));
        Assert.assertEquals((int)statementList.size(), (int)3);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp/databags"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)("{md} /tmp/databags/" + databag.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expected.render(OsFamily.UNIX));
    }

    public void testCreateDatabagsIfNecessaryWithOneDatabagWithMultipleItemsAndCustomPath() {
        ImmutableList.Builder statements = ImmutableList.builder();
        DataBag databag = DataBag.builder().name("foo").item("item1", "{\"foo\":\"bar\"}").item("item2", "{\"bar\":\"foo\"}").build();
        ChefSolo solo = ChefSolo.builder().dataBagPath("/tmp/databags").defineDataBag(databag).build();
        solo.createDatabagsIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expectedItem1 = Statements.createOrOverwriteFile((String)"/tmp/databags/foo/item1.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\"}"));
        Statement expectedItem2 = Statements.createOrOverwriteFile((String)"/tmp/databags/foo/item2.json", (Iterable)ImmutableSet.of((Object)"{\"bar\":\"foo\"}"));
        Assert.assertEquals((int)statementList.size(), (int)4);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp/databags"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)("{md} /tmp/databags/" + databag.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expectedItem1.render(OsFamily.UNIX));
        Assert.assertEquals((String)((Statement)statementList.get(3)).render(OsFamily.UNIX), (String)expectedItem2.render(OsFamily.UNIX));
    }

    public void testCreateDatabagsIfNecessaryWithMultipleDatabagsAndCustomPath() {
        ImmutableList.Builder statements = ImmutableList.builder();
        DataBag databagFoo = DataBag.builder().name("foo").item("itemFoo", "{\"foo\":\"bar\"}").build();
        DataBag databagBar = DataBag.builder().name("bar").item("itemBar", "{\"bar\":\"foo\"}").build();
        ChefSolo solo = ChefSolo.builder().dataBagPath("/tmp/databags").defineDataBag(databagFoo).defineDataBag(databagBar).build();
        solo.createDatabagsIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expectedFoo = Statements.createOrOverwriteFile((String)"/tmp/databags/foo/itemFoo.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\"}"));
        Statement expectedBar = Statements.createOrOverwriteFile((String)"/tmp/databags/bar/itemBar.json", (Iterable)ImmutableSet.of((Object)"{\"bar\":\"foo\"}"));
        Assert.assertEquals((int)statementList.size(), (int)5);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp/databags"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)("{md} /tmp/databags/" + databagFoo.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expectedFoo.render(OsFamily.UNIX));
        Assert.assertEquals((Object)statementList.get(3), (Object)Statements.exec((String)("{md} /tmp/databags/" + databagBar.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(4)).render(OsFamily.UNIX), (String)expectedBar.render(OsFamily.UNIX));
    }

    public void testCreateDatabagsIfNecessaryWithMultipleDatabagsAndMultipleItemsAndCustomPath() {
        ImmutableList.Builder statements = ImmutableList.builder();
        DataBag databagFoo = DataBag.builder().name("foo").item("itemFoo", "{\"foo\":\"bar\"}").build();
        DataBag databagBar = DataBag.builder().name("bar").item("itemBar", "{\"bar\":\"foo\"}").item("extra", "{\"extra\":[]}").build();
        ChefSolo solo = ChefSolo.builder().dataBagPath("/tmp/databags").defineDataBag(databagFoo).defineDataBag(databagBar).build();
        solo.createDatabagsIfNecessary(statements);
        ImmutableList statementList = statements.build();
        Statement expectedFoo = Statements.createOrOverwriteFile((String)"/tmp/databags/foo/itemFoo.json", (Iterable)ImmutableSet.of((Object)"{\"foo\":\"bar\"}"));
        Statement expectedBar = Statements.createOrOverwriteFile((String)"/tmp/databags/bar/itemBar.json", (Iterable)ImmutableSet.of((Object)"{\"bar\":\"foo\"}"));
        Statement expectedExtra = Statements.createOrOverwriteFile((String)"/tmp/databags/bar/extra.json", (Iterable)ImmutableSet.of((Object)"{\"extra\":[]}"));
        Assert.assertEquals((int)statementList.size(), (int)6);
        Assert.assertEquals((Object)statementList.get(0), (Object)Statements.exec((String)"{md} /tmp/databags"));
        Assert.assertEquals((Object)statementList.get(1), (Object)Statements.exec((String)("{md} /tmp/databags/" + databagFoo.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(2)).render(OsFamily.UNIX), (String)expectedFoo.render(OsFamily.UNIX));
        Assert.assertEquals((Object)statementList.get(3), (Object)Statements.exec((String)("{md} /tmp/databags/" + databagBar.getName())));
        Assert.assertEquals((String)((Statement)statementList.get(4)).render(OsFamily.UNIX), (String)expectedBar.render(OsFamily.UNIX));
        Assert.assertEquals((String)((Statement)statementList.get(5)).render(OsFamily.UNIX), (String)expectedExtra.render(OsFamily.UNIX));
    }

    @Test(expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="windows not yet implemented")
    public void testChefSoloInWindows() {
        ChefSolo.builder().cookbooksArchiveLocation("/tmp/cookbooks").build().render(OsFamily.WINDOWS);
    }

    public void testChefWoloWithDefaultConfiguration() throws IOException {
        String script = ChefSolo.builder().build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname`\n"));
    }

    public void testChefWoloWithNodeName() throws IOException {
        String script = ChefSolo.builder().nodeName("foo").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N foo\n"));
    }

    public void testChefSoloWithGroup() throws IOException {
        String script = ChefSolo.builder().group("foo").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -g foo\n"));
    }

    public void testChefSoloWithInterval() throws IOException {
        String script = ChefSolo.builder().interval(Integer.valueOf(15)).build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -i 15\n"));
    }

    public void testChefSoloWithLogLevel() throws IOException {
        String script = ChefSolo.builder().logLevel("debug").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -l debug\n"));
    }

    public void testChefSoloWithLogFile() throws IOException {
        String script = ChefSolo.builder().logFile("/var/log/solo.log").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -L /var/log/solo.log\n"));
    }

    public void testChefSoloWithCookbooksLocation() throws IOException {
        String script = ChefSolo.builder().cookbooksArchiveLocation("/tmp/cookbooks").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -r /tmp/cookbooks\n"));
    }

    public void testChefSoloWithSplay() throws IOException {
        String script = ChefSolo.builder().splay(Integer.valueOf(15)).build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -s 15\n"));
    }

    public void testChefSoloWithUser() throws IOException {
        String script = ChefSolo.builder().user("foo").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems() + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname` -u foo\n"));
    }

    public void testChefSoloWithChefGemVersion() throws IOException {
        String script = ChefSolo.builder().chefVersion(">= 0.10.8").build().render(OsFamily.UNIX);
        Assert.assertEquals((String)script, (String)(ChefSoloTest.installChefGems(">= 0.10.8") + ChefSoloTest.createConfigFile() + ChefSoloTest.createNodeFile() + "chef-solo -c /var/chef/solo.rb -j /var/chef/node.json -N `hostname`\n"));
    }

    private static String installChefGems() throws IOException {
        return "gem install chef --no-rdoc --no-ri\n";
    }

    private static String installChefGems(String version) throws IOException {
        return "gem install chef -v '" + version + "' --no-rdoc --no-ri\n";
    }

    private static String createConfigFile() {
        return "mkdir -p /var/chef\nmkdir -p /var/chef/cookbooks\ncat > /var/chef/solo.rb <<-'END_OF_JCLOUDS_FILE'\n\tfile_cache_path \"/var/chef\"\n\tcookbook_path [\"/var/chef/cookbooks\"]\n\trole_path \"/var/chef/roles\"\n\tdata_bag_path \"/var/chef/data_bags\"\nEND_OF_JCLOUDS_FILE\n";
    }

    private static String createNodeFile() {
        return "cat > /var/chef/node.json <<-'END_OF_JCLOUDS_FILE'\n\t{\"run_list\":[]}\nEND_OF_JCLOUDS_FILE\n";
    }
}

