/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.java.InstallJDK;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="InstallJDKTest")
public class InstallJDKTest {
    Statement installJDK = InstallJDK.fromOpenJDK();

    public void testInstallJDKUNIX() throws IOException {
        Assert.assertEquals((String)InstallJDK.fromOpenJDK().render(OsFamily.UNIX), (String)"setupPublicCurl || return 1\ninstallOpenJDK || return 1\n");
    }

    public void testInstallJDKUNIXInScriptBuilderSourcesSetupPublicCurl() throws IOException {
        Assert.assertEquals((String)InitScript.builder().name("install_jdk").run(InstallJDK.fromOpenJDK()).build().render(OsFamily.UNIX), (String)Resources.toString((URL)Resources.getResource((String)("test_install_jdk_scriptbuilder." + ShellToken.SH.to(OsFamily.UNIX))), (Charset)Charsets.UTF_8));
    }

    public void testInstallJDKUNIXWithURL() throws IOException {
        Assert.assertEquals((String)InstallJDK.fromURL((URI)URI.create("http://foo")).render(OsFamily.UNIX), (String)"setupPublicCurl || return 1\ninstallJDKFromURL http://foo || return 1\n");
    }
}

