/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.loaders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.services.AWSSecurityGroupClient;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2CreateSecurityGroupIfNeeded
extends CacheLoader<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final AWSSecurityGroupClient securityClient;
    protected final Predicate<RegionAndName> securityGroupEventualConsistencyDelay;

    @Inject
    public AWSEC2CreateSecurityGroupIfNeeded(AWSEC2Client ec2Client, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this(((AWSEC2Client)Preconditions.checkNotNull((Object)ec2Client, (Object)"ec2Client")).getSecurityGroupServices(), securityGroupEventualConsistencyDelay);
    }

    public AWSEC2CreateSecurityGroupIfNeeded(AWSSecurityGroupClient securityClient, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this.securityClient = (AWSSecurityGroupClient)Preconditions.checkNotNull((Object)securityClient, (Object)"securityClient");
        this.securityGroupEventualConsistencyDelay = (Predicate)Preconditions.checkNotNull(securityGroupEventualConsistencyDelay, (Object)"securityGroupEventualConsistencyDelay");
    }

    public String load(RegionAndName from) {
        RegionNameAndIngressRules realFrom = (RegionNameAndIngressRules)RegionNameAndIngressRules.class.cast(from);
        this.createSecurityGroupInRegion(from.getRegion(), from.getName(), realFrom.getPorts());
        return from.getName();
    }

    private void createSecurityGroupInRegion(String region, String name, int ... ports) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.logger.debug(">> creating securityGroup region(%s) name(%s)", new Object[]{region, name});
        try {
            ImmutableSet perms;
            this.securityClient.createSecurityGroupInRegion(region, name, name);
            boolean created = this.securityGroupEventualConsistencyDelay.apply((Object)new RegionAndName(region, name));
            if (!created) {
                throw new RuntimeException(String.format("security group %s/%s is not available after creating", region, name));
            }
            this.logger.debug("<< created securityGroup(%s)", new Object[]{name});
            ImmutableSet.Builder permissions = ImmutableSet.builder();
            if (ports.length > 0) {
                for (Map.Entry range : ComputeServiceUtils.getPortRangesFromList((int[])ports).entrySet()) {
                    permissions.add((Object)IpPermission.builder().fromPort(((Integer)range.getKey()).intValue()).toPort(((Integer)range.getValue()).intValue()).ipProtocol(IpProtocol.TCP).ipRange("0.0.0.0/0").build());
                }
                String myOwnerId = ((SecurityGroup)Iterables.get((Iterable)this.securityClient.describeSecurityGroupsInRegion(region, new String[]{name}), (int)0)).getOwnerId();
                permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.TCP).userIdGroupPair(myOwnerId, name).build());
                permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.UDP).userIdGroupPair(myOwnerId, name).build());
            }
            if ((perms = permissions.build()).size() > 0) {
                String id = ((SecurityGroup)Iterables.get((Iterable)this.securityClient.describeSecurityGroupsInRegion(region, new String[]{name}), (int)0)).getId();
                this.logger.debug(">> authorizing securityGroup region(%s) name(%s) IpPermissions(%s)", new Object[]{region, name, perms});
                this.securityClient.authorizeSecurityGroupIngressInRegion(region, id, (Iterable<IpPermission>)perms);
                this.logger.debug("<< authorized securityGroup(%s)", new Object[]{name});
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{name});
        }
    }
}

