/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.s3.AWSS3ApiMetadata;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.blobstore.options.AWSS3PutOptions;
import org.jclouds.aws.s3.domain.DeleteResult;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.http.BaseJettyTest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.ByteSources;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.rest.RestContext;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.S3ClientLiveTest;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AWSS3ClientLiveTest")
public class AWSS3ClientLiveTest
extends S3ClientLiveTest {
    private InputSupplier<InputStream> oneHundredOneConstitutions;
    private byte[] oneHundredOneConstitutionsMD5;
    private static long oneHundredOneConstitutionsLength;

    public AWSS3ClientLiveTest() {
        this.provider = "aws-s3";
    }

    public AWSS3Client getApi() {
        return (AWSS3Client)((RestContext)((BlobStoreContext)this.view).unwrap(AWSS3ApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    @BeforeClass(groups={"integration", "live"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        super.setUpResourcesOnThisThread(testContext);
        this.oneHundredOneConstitutions = AWSS3ClientLiveTest.getTestDataSupplier();
        this.oneHundredOneConstitutionsMD5 = ByteSources.asByteSource((InputStream)((InputStream)this.oneHundredOneConstitutions.getInput())).hash(Hashing.md5()).asBytes();
    }

    public static InputSupplier<InputStream> getTestDataSupplier() throws IOException {
        byte[] oneConstitution = ByteStreams.toByteArray((InputStream)new GZIPInputStream(BaseJettyTest.class.getResourceAsStream("/const.txt.gz")));
        InputSupplier constitutionSupplier = ByteStreams.newInputStreamSupplier((byte[])oneConstitution);
        InputSupplier temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{constitutionSupplier});
        for (oneHundredOneConstitutionsLength = (long)oneConstitution.length; oneHundredOneConstitutionsLength < 0x500000L; oneHundredOneConstitutionsLength += (long)oneConstitution.length) {
            temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{temp, constitutionSupplier});
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartSynchronously() throws InterruptedException, IOException {
        String containerName = this.getContainerName();
        S3Object object = null;
        try {
            String key = "constitution.txt";
            String uploadId = this.getApi().initiateMultipartUpload(containerName, ObjectMetadataBuilder.create().key(key).contentMD5(this.oneHundredOneConstitutionsMD5).build(), new PutObjectOptions[0]);
            byte[] buffer = ByteStreams.toByteArray(this.oneHundredOneConstitutions);
            Assert.assertEquals((long)oneHundredOneConstitutionsLength, (long)buffer.length);
            ByteArrayPayload part1 = Payloads.newByteArrayPayload((byte[])buffer);
            part1.getContentMetadata().setContentLength(Long.valueOf(buffer.length));
            part1.getContentMetadata().setContentMD5(this.oneHundredOneConstitutionsMD5);
            String eTagOf1 = null;
            try {
                eTagOf1 = this.getApi().uploadPart(containerName, key, 1, uploadId, (Payload)part1);
            }
            catch (KeyNotFoundException e) {
                eTagOf1 = this.getApi().uploadPart(containerName, key, 1, uploadId, (Payload)part1);
            }
            String eTag = this.getApi().completeMultipartUpload(containerName, key, uploadId, (Map)ImmutableMap.of((Object)1, (Object)eTagOf1));
            assert (!eTagOf1.equals(eTag));
            object = this.getApi().getObject(containerName, key, new GetOptions[0]);
            Assert.assertEquals((byte[])ByteStreams.toByteArray((InputSupplier)object.getPayload()), (byte[])buffer);
            Assert.assertEquals((byte[])object.getPayload().getContentMetadata().getContentMD5(), null);
            Assert.assertEquals((byte[])this.getApi().headObject(containerName, key).getContentMetadata().getContentMD5(), null);
        }
        finally {
            if (object != null) {
                object.getPayload().close();
            }
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartChunkedFileStream() throws IOException, InterruptedException {
        File file = new File("target/const.txt");
        Files.copy(this.oneHundredOneConstitutions, (File)file);
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            blobStore.createContainerInLocation(null, containerName);
            Blob blob = blobStore.blobBuilder("const.txt").payload(file).build();
            blobStore.putBlob(containerName, blob, PutOptions.Builder.multipart());
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartAsynchronouslySmallBlob() throws IOException, InterruptedException, Exception {
        String containerName = this.getContainerName();
        try {
            AsyncBlobStore asyncBlobStore = ((BlobStoreContext)this.view).getAsyncBlobStore();
            asyncBlobStore.createContainerInLocation(null, containerName).get();
            Blob blob = asyncBlobStore.blobBuilder("small").payload("small").build();
            asyncBlobStore.putBlob(containerName, blob, PutOptions.Builder.multipart()).get();
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutWithReducedRedundancyStorage() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            String blobName = "test-rrs";
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            blobStore.createContainerInLocation(null, containerName);
            Blob blob = blobStore.blobBuilder(blobName).payload("something").build();
            blobStore.putBlob(containerName, blob, (PutOptions)AWSS3PutOptions.Builder.storageClass((ObjectMetadata.StorageClass)ObjectMetadata.StorageClass.REDUCED_REDUNDANCY));
            S3Client s3Client = (S3Client)S3Client.class.cast(((RestContext)((BlobStoreContext)this.view).unwrap(AWSS3ApiMetadata.CONTEXT_TOKEN)).getApi());
            ListBucketResponse response = s3Client.listBucket(containerName, new ListBucketOptions[]{ListBucketOptions.Builder.withPrefix((String)blobName)});
            ObjectMetadata metadata = (ObjectMetadata)response.iterator().next();
            Assert.assertEquals((Object)metadata.getStorageClass(), (Object)ObjectMetadata.StorageClass.REDUCED_REDUNDANCY);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseBucketWithUpperCaseName() throws Exception {
        String bucketName = CONTAINER_PREFIX + "-TestBucket";
        String blobName = "TestBlob.txt";
        StorageMetadata container = null;
        BlobStore store = ((BlobStoreContext)this.view).getBlobStore();
        try {
            store.createContainerInLocation(null, bucketName);
            for (StorageMetadata metadata : store.list()) {
                if (!metadata.getName().equals(bucketName)) continue;
                container = metadata;
                break;
            }
            Assert.assertNotNull(container);
            store.putBlob(bucketName, store.blobBuilder(blobName).payload("This is a test!").contentType("text/plain").build());
            Assert.assertNotNull((Object)store.getBlob(bucketName, blobName));
        }
        finally {
            if (container != null) {
                store.deleteContainer(bucketName);
            }
        }
        Location location = null;
        for (Location pLocation : store.listAssignableLocations()) {
            if (ImmutableSet.of((Object)"us-standard", (Object)"us-east-1", (Object)"us-west-1", (Object)"us-west-2").contains((Object)pLocation.getId())) continue;
            location = pLocation;
            break;
        }
        try {
            store.createContainerInLocation(location, bucketName);
            Assert.fail((String)"Should had failed because in non-US regions, mixed-case bucket names are invalid.");
        }
        catch (AWSResponseException e) {
            Assert.assertEquals((String)"InvalidBucketName", (String)e.getError().getCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMultipleObjects() throws InterruptedException {
        String container = this.getContainerName();
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < 5; ++i) {
                String key = UUID.randomUUID().toString();
                Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).payload("").build();
                ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
                builder.add((Object)key);
            }
            ImmutableSet keys = builder.build();
            DeleteResult result = this.getApi().deleteObjects(container, (Iterable)keys);
            Assert.assertTrue((boolean)result.getDeleted().containsAll((Collection<?>)keys));
            Assert.assertEquals((int)result.getErrors().size(), (int)0);
            for (String key : keys) {
                this.assertConsistencyAwareBlobDoesntExist(container, key);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirectoryEndingWithSlash() throws InterruptedException {
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            blobStore.createDirectory(containerName, "someDir");
            blobStore.removeBlob(containerName, "someDir/");
            Assert.assertEquals((boolean)blobStore.directoryExists(containerName, "someDir"), (boolean)false);
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

