/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import org.jclouds.aws.s3.config.AWSS3RestClientModule;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.s3.blobstore.S3BlobSignerExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AWSS3BlobSignerExpectTest")
public class AWSS3BlobSignerExpectTest
extends S3BlobSignerExpectTest {
    private static final String DATE = "Thu, 05 Jun 2008 16:38:19 GMT";

    public AWSS3BlobSignerExpectTest() {
        this.provider = "aws-s3";
    }

    protected HttpRequest getBlobWithTime() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://container.s3.amazonaws.com/name?Expires=1212683902&AWSAccessKeyId=identity&Signature=Y4Ac4sZfBemGZmgfG78F7IX%2BIFg%3D").addHeader("Host", new String[]{"container.s3.amazonaws.com"})).addHeader("Date", new String[]{DATE})).build();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSignGetBlobWithTime() {
        BlobStore getBlobWithTime = (BlobStore)this.requestsSendResponses(this.init());
        HttpRequest compare = this.getBlobWithTime();
        Assert.assertEquals((Object)getBlobWithTime.getContext().getSigner().signGetBlob(this.container, this.name, 3L), (Object)compare);
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://container.s3.amazonaws.com/name?Expires=1212683902&AWSAccessKeyId=identity&Signature=genkB2vLxe3AWV/bPvRTMqQts7E%3D").addHeader("Expect", new String[]{"100-continue"})).addHeader("Host", new String[]{"container.s3.amazonaws.com"})).addHeader("Date", new String[]{DATE})).build();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSignPutBlobWithTime() throws Exception {
        BlobStore signPutBloblWithTime = (BlobStore)this.requestsSendResponses(this.init());
        Blob blob = signPutBloblWithTime.blobBuilder(this.name).payload(this.text).contentType("text/plain").build();
        HttpRequest compare = this.putBlobWithTime();
        compare.setPayload(blob.getPayload());
        Assert.assertEquals((Object)signPutBloblWithTime.getContext().getSigner().signPutBlob(this.container, blob, 3L), (Object)compare);
    }

    protected Module createModule() {
        return new TestAWSS3RestClientModule();
    }

    @ConfiguresRestClient
    private static final class TestAWSS3RestClientModule
    extends AWSS3RestClientModule {
        private TestAWSS3RestClientModule() {
        }

        @TimeStamp
        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return AWSS3BlobSignerExpectTest.DATE;
        }
    }
}

