/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.aws.s3.domain.DeleteResult;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class ErrorEntryHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Map.Entry<String, DeleteResult.Error>> {
    private StringBuilder accumulator = new StringBuilder();
    private String key;
    private String code;
    private String message;

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.accumulator.append(chars, start, length);
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Key")) {
            this.key = this.accumulator.toString().trim();
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Code")) {
            this.code = this.accumulator.toString().trim();
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Message")) {
            this.message = this.accumulator.toString().trim();
        }
        this.accumulator = new StringBuilder();
    }

    public Map.Entry<String, DeleteResult.Error> getResult() {
        return Maps.immutableEntry((Object)this.key, (Object)new DeleteResult.Error(this.code, this.message));
    }
}

