/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Date;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.AzureBlobProviderMetadata;
import org.jclouds.azureblob.config.AzureBlobRestClientModule;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AzureBlobRequestSignerTest")
public class AzureBlobRequestSignerTest
extends BaseAsyncClientTest<AzureBlobAsyncClient> {
    private BlobRequestSigner signer;
    private Blob.Factory blobFactory;

    public AzureBlobRequestSignerTest() {
        this.credential = "aaaabbbb";
    }

    public void testSignGetBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signGetBlob("container", "name");
        this.assertRequestLineEquals(request, "GET https://identity.blob.core.windows.net/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: SharedKeyLite identity:nutCr98JWBu7wbe1p9rDiyOXg3o6UqI4tEZ29bctKEU=\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nx-ms-version: 2009-09-19\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignRemoveBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signRemoveBlob("container", "name");
        this.assertRequestLineEquals(request, "DELETE https://identity.blob.core.windows.net/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: SharedKeyLite identity:GRixvGXJ05tuWANrM5xeWOAAVqfztvmPLpwCRcWPZEk=\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nx-ms-version: 2009-09-19\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignPutBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Blob blob = this.blobFactory.create(null);
        blob.getMetadata().setName("name");
        blob.setPayload("");
        blob.getPayload().getContentMetadata().setContentLength(Long.valueOf(2L));
        blob.getPayload().getContentMetadata().setContentMD5(new byte[]{0, 2, 4, 8});
        blob.getPayload().getContentMetadata().setContentType("text/plain");
        blob.getPayload().getContentMetadata().setExpires(new Date(1000L));
        HttpRequest request = this.signer.signPutBlob("container", blob);
        this.assertRequestLineEquals(request, "PUT https://identity.blob.core.windows.net/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: SharedKeyLite identity:ssvK6ZB8GMqRcp1lBpY9vIzbLKL9Goxh7wZ2YhfHNzQ=\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nExpect: 100-continue\nx-ms-blob-type: BlockBlob\nx-ms-version: 2009-09-19\n");
        this.assertContentHeadersEqual(request, "text/plain", null, null, null, 2L, new byte[]{0, 2, 4, 8}, new Date(1000L));
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobFactory = (Blob.Factory)this.injector.getInstance(Blob.Factory.class);
        this.signer = (BlobRequestSigner)this.injector.getInstance(BlobRequestSigner.class);
    }

    protected void checkFilters(HttpRequest request) {
    }

    protected Module createModule() {
        return new TestAzureBlobRestClientModule();
    }

    public AzureBlobProviderMetadata createProviderMetadata() {
        return new AzureBlobProviderMetadata();
    }

    @ConfiguresRestClient
    private static final class TestAzureBlobRestClientModule
    extends AzureBlobRestClientModule {
        private TestAzureBlobRestClientModule() {
        }

        protected void configure() {
            super.configure();
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "Thu, 05 Jun 2008 16:38:19 GMT";
        }
    }
}

