/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.options.ListContainerOptions;

@Singleton
public class ListBlobsOptionsToListOptions
implements Function<ListBlobsOptions[], ListContainerOptions> {
    public ListContainerOptions apply(ListBlobsOptions[] optionsList) {
        ListContainerOptions options = new ListContainerOptions();
        if (optionsList.length != 0) {
            if (optionsList[0].getDelimiter() == null) {
                options.recursive();
            } else if (!optionsList[0].getDelimiter().equals("/")) {
                throw new IllegalArgumentException("only '/' is allowed as a blobstore delimiter");
            }
            if (optionsList[0].getMarker() != null) {
                options.afterMarker(optionsList[0].getMarker());
            }
            if (optionsList[0].getMaxResults() != null) {
                options.maxResults(optionsList[0].getMaxResults().intValue());
            }
            if (optionsList[0].getPrefix() != null) {
                options.inDirectory(optionsList[0].getPrefix());
            }
            if (optionsList[0].getIncludeMetadata()) {
                options.withDetails();
            }
        }
        return options;
    }
}

