/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.integration;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.io.ByteSources;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class AzureBlobIntegrationLiveTest
extends BaseBlobIntegrationTest {
    private InputSupplier<InputStream> oneHundredOneConstitutions;
    private byte[] oneHundredOneConstitutionsMD5;
    private static final InputStream ZERO_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return 0;
        }

        @Override
        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            int length = Math.min(len, b.length - off);
            Arrays.fill(b, off, length, (byte)0);
            return length;
        }
    };

    public AzureBlobIntegrationLiveTest() {
        this.provider = "azureblob";
    }

    public void testGetIfMatch() throws InterruptedException {
    }

    public void testGetIfModifiedSince() throws InterruptedException {
    }

    public void testCreateBlobWithExpiry() throws InterruptedException {
        throw new SkipException("Expires header unsupported: http://msdn.microsoft.com/en-us/library/windowsazure/dd179404.aspx#Subheading3");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testPutObjectStream() throws InterruptedException, IOException, ExecutionException {
        super.testPutObjectStream();
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        assert (blob.getPayload().getContentMetadata().getContentDisposition() == null);
        assert (blob.getMetadata().getContentMetadata().getContentDisposition() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartChunkedFileStream() throws IOException, InterruptedException {
        this.oneHundredOneConstitutions = AzureBlobIntegrationLiveTest.getTestDataSupplier();
        this.oneHundredOneConstitutionsMD5 = ByteSources.asByteSource((InputStream)((InputStream)this.oneHundredOneConstitutions.getInput())).hash(Hashing.md5()).asBytes();
        File file = new File("target/const.txt");
        Files.copy(this.oneHundredOneConstitutions, (File)file);
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            blobStore.createContainerInLocation(null, containerName);
            Blob blob = blobStore.blobBuilder("const.txt").payload(file).build();
            String expected = blobStore.putBlob(containerName, blob, PutOptions.Builder.multipart());
            String etag = blobStore.blobMetadata(containerName, "const.txt").getETag();
            Assert.assertEquals((String)etag, (String)expected);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipartChunkedFileStreamPowerOfTwoSize() throws IOException, InterruptedException {
        long limit = 0x400000L;
        InputSupplier<InputStream> input = new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return ByteStreams.limit((InputStream)ZERO_INPUT_STREAM, (long)0x400000L);
            }
        };
        File file = new File("target/const.txt");
        Files.copy((InputSupplier)input, (File)file);
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            blobStore.createContainerInLocation(null, containerName);
            Blob blob = blobStore.blobBuilder("const.txt").payload(file).build();
            String expected = blobStore.putBlob(containerName, blob, PutOptions.Builder.multipart());
            String etag = blobStore.blobMetadata(containerName, "const.txt").getETag();
            Assert.assertEquals((String)etag, (String)expected);
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

