/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateContainerOptionsTest {
    public void testPublicAccess() {
        CreateContainerOptions options = new CreateContainerOptions().withPublicAccess(PublicAccess.BLOB);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"blob"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-blob-public-access"));
    }

    public void testPublicAccessStatic() {
        CreateContainerOptions options = CreateContainerOptions.Builder.withPublicAccess((PublicAccess)PublicAccess.BLOB);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"blob"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-blob-public-access"));
    }

    public void testMetadata() {
        CreateContainerOptions options = new CreateContainerOptions().withMetadata((Multimap)ImmutableMultimap.of((Object)"test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-meta-test"));
    }

    public void testMetadataAlreadyPrefixed() {
        CreateContainerOptions options = new CreateContainerOptions().withMetadata((Multimap)ImmutableMultimap.of((Object)"x-ms-meta-test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-meta-test"));
    }

    public void testMetadataStatic() {
        CreateContainerOptions options = CreateContainerOptions.Builder.withMetadata((Multimap)ImmutableMultimap.of((Object)"test", (Object)"foo"));
        Assert.assertEquals((Collection)ImmutableList.of((Object)"foo"), (Collection)options.buildRequestHeaders().get((Object)"x-ms-meta-test"));
    }
}

