/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jclouds.Fallback;
import org.jclouds.azure.storage.AzureStorageResponseException;

public final class AzureBlobFallbacks {
    private AzureBlobFallbacks() {
    }

    public static final class FalseIfContainerAlreadyExists
    implements Fallback<Boolean> {
        public ListenableFuture<Boolean> create(Throwable t) throws Exception {
            return Futures.immediateFuture((Object)this.createOrPropagate(t));
        }

        public Boolean createOrPropagate(Throwable t) throws Exception {
            AzureStorageResponseException responseException;
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof AzureStorageResponseException && "ContainerAlreadyExists".equals((responseException = (AzureStorageResponseException)AzureStorageResponseException.class.cast(t)).getError().getCode())) {
                return false;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

