/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.azureblob.blobstore.functions.ListBlobsResponseToResourceList;
import org.jclouds.azureblob.blobstore.functions.ListOptionsToListBlobsOptions;
import org.jclouds.azureblob.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;

@Deprecated
@Singleton
public class AzureAsyncBlobStore
extends BaseAsyncBlobStore {
    private final AzureBlobAsyncClient async;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions;
    private final ListBlobsResponseToResourceList azure2BlobStoreResourceList;
    private final AzureBlobToBlob azureBlob2Blob;
    private final BlobToAzureBlob blob2AzureBlob;
    private final BlobPropertiesToBlobMetadata blob2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<MultipartUploadStrategy> multipartUploadStrategy;

    @Inject
    AzureAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AzureBlobAsyncClient async, ContainerToResourceMetadata container2ResourceMd, ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions, ListBlobsResponseToResourceList azure2BlobStoreResourceList, AzureBlobToBlob azureBlob2Blob, BlobToAzureBlob blob2AzureBlob, BlobPropertiesToBlobMetadata blob2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<MultipartUploadStrategy> multipartUploadStrategy) {
        super(context, blobUtils, userExecutor, defaultLocation, locations);
        this.async = (AzureBlobAsyncClient)Preconditions.checkNotNull((Object)async, (Object)"async");
        this.container2ResourceMd = (ContainerToResourceMetadata)Preconditions.checkNotNull((Object)container2ResourceMd, (Object)"container2ResourceMd");
        this.blobStore2AzureContainerListOptions = (ListOptionsToListBlobsOptions)Preconditions.checkNotNull((Object)blobStore2AzureContainerListOptions, (Object)"blobStore2AzureContainerListOptions");
        this.azure2BlobStoreResourceList = (ListBlobsResponseToResourceList)Preconditions.checkNotNull((Object)azure2BlobStoreResourceList, (Object)"azure2BlobStoreResourceList");
        this.azureBlob2Blob = (AzureBlobToBlob)Preconditions.checkNotNull((Object)azureBlob2Blob, (Object)"azureBlob2Blob");
        this.blob2AzureBlob = (BlobToAzureBlob)Preconditions.checkNotNull((Object)blob2AzureBlob, (Object)"blob2AzureBlob");
        this.blob2BlobMd = (BlobPropertiesToBlobMetadata)Preconditions.checkNotNull((Object)blob2BlobMd, (Object)"blob2BlobMd");
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.multipartUploadStrategy = (Provider)Preconditions.checkNotNull(multipartUploadStrategy, (Object)"multipartUploadStrategy");
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.transform(this.async.listContainers(ListOptions.Builder.includeMetadata()), (Function)new Function<BoundedSet<ContainerProperties>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(BoundedSet<ContainerProperties> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)AzureAsyncBlobStore.this.container2ResourceMd), from.getNextMarker());
            }
        }, (Executor)this.userExecutor);
    }

    public ListenableFuture<Boolean> containerExists(String container) {
        return this.async.containerExists(container);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container) {
        return this.async.createContainer(container, new CreateContainerOptions[0]);
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container, ListContainerOptions options) {
        ListBlobsOptions azureOptions = this.blobStore2AzureContainerListOptions.apply(options);
        ListenableFuture<ListBlobsResponse> returnVal = this.async.listBlobs(container, azureOptions.includeMetadata());
        return Futures.transform(returnVal, (Function)this.azure2BlobStoreResourceList, (Executor)this.userExecutor);
    }

    public ListenableFuture<Void> deleteContainer(String container) {
        return this.async.deleteContainer(container);
    }

    public ListenableFuture<Blob> getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions azureOptions = this.blob2ObjectGetOptions.apply(options);
        ListenableFuture<AzureBlob> returnVal = this.async.getBlob(container, key, azureOptions);
        return Futures.transform(returnVal, (Function)this.azureBlob2Blob, (Executor)this.userExecutor);
    }

    public ListenableFuture<String> putBlob(String container, Blob blob) {
        return this.async.putBlob(container, this.blob2AzureBlob.apply(blob));
    }

    public ListenableFuture<Void> removeBlob(String container, String key) {
        return this.async.deleteBlob(container, key);
    }

    public ListenableFuture<Boolean> blobExists(String container, String name) {
        return this.async.blobExists(container, name);
    }

    public ListenableFuture<Void> putBlock(String container, String name, String blockId, Payload object) {
        return this.async.putBlock(container, name, blockId, object);
    }

    public ListenableFuture<String> putBlockList(String container, String name, List<String> blockIdList) {
        return this.async.putBlockList(container, name, blockIdList);
    }

    public ListenableFuture<ListBlobBlocksResponse> getBlockList(String container, String name) {
        return this.async.getBlockList(container, name);
    }

    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        return Futures.transform(this.async.getBlobProperties(container, key), (Function)new Function<BlobProperties, BlobMetadata>(){

            public BlobMetadata apply(BlobProperties from) {
                return AzureAsyncBlobStore.this.blob2BlobMd.apply(from);
            }
        }, (Executor)this.userExecutor);
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        throw new UnsupportedOperationException("please use deleteContainer");
    }

    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            throw new UnsupportedOperationException("Multipart upload not supported in AzureAsyncBlobStore");
        }
        return this.putBlob(container, blob);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        CreateContainerOptions createContainerOptions = new CreateContainerOptions();
        if (options.isPublicRead()) {
            createContainerOptions.withPublicAccess(PublicAccess.CONTAINER);
        }
        return this.async.createContainer(container, createContainerOptions);
    }
}

