/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.PrefixToResourceMetadata;

@Singleton
public class ListBlobsResponseToResourceList
implements Function<ListBlobsResponse, PageSet<? extends StorageMetadata>> {
    private final BlobPropertiesToBlobMetadata object2blobMd;
    private final PrefixToResourceMetadata prefix2ResourceMd;
    protected final Function<StorageMetadata, String> indexer = new Function<StorageMetadata, String>(){

        public String apply(StorageMetadata from) {
            return from.getName();
        }
    };

    @Inject
    public ListBlobsResponseToResourceList(BlobPropertiesToBlobMetadata object2blobMd, PrefixToResourceMetadata prefix2ResourceMd) {
        this.object2blobMd = object2blobMd;
        this.prefix2ResourceMd = prefix2ResourceMd;
    }

    public PageSet<? extends StorageMetadata> apply(ListBlobsResponse from) {
        HashSet contents = Sets.newHashSet((Iterable)Iterables.transform((Iterable)((Object)from), (Function)this.object2blobMd));
        ImmutableMap nameToMd = Maps.uniqueIndex((Iterable)contents, this.indexer);
        for (String prefix : from.getBlobPrefixes()) {
            String string = prefix = prefix.endsWith("/") ? prefix.substring(0, prefix.lastIndexOf(47)) : prefix;
            if (nameToMd.containsKey(prefix) && ((StorageMetadata)nameToMd.get(prefix)).getType() == StorageType.RELATIVE_PATH) continue;
            contents.add(this.prefix2ResourceMd.apply(prefix));
        }
        return new PageSetImpl((Iterable)contents, from.getNextMarker());
    }
}

