/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;

public class AzureBlobBlockUploadStrategy
implements MultipartUploadStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    private Logger logger = Logger.NULL;
    private final AzureBlobClient client;
    private final PayloadSlicer slicer;

    @Inject
    public AzureBlobBlockUploadStrategy(AzureBlobClient client, PayloadSlicer slicer) {
        this.client = (AzureBlobClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.slicer = (PayloadSlicer)Preconditions.checkNotNull((Object)slicer, (Object)"slicer");
    }

    @Override
    public String execute(String container, Blob blob) {
        String blobName = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        Long length = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull((Object)length, (Object)"please invoke payload.getContentMetadata().setContentLength(length) prior to azure block upload");
        Preconditions.checkArgument((length <= 209715200000L ? 1 : 0) != 0);
        long offset = 0L;
        ArrayList blockIds = Lists.newArrayList();
        int blockCount = 0;
        int totalBlocks = (int)Math.ceil((double)length.longValue() / 4194304.0);
        long bytesWritten = 0L;
        while (offset < length) {
            ++blockCount;
            long chunkSize = 0x400000L;
            if (length - offset < 0x400000L) {
                chunkSize = length % 0x400000L;
            }
            bytesWritten += chunkSize;
            Payload block = this.slicer.slice(payload, offset, chunkSize);
            String blockName = blobName + "-" + (offset += 0x400000L) + "-" + new SecureRandom().nextInt();
            byte[] blockIdBytes = Hashing.md5().hashBytes(blockName.getBytes()).asBytes();
            String blockId = BaseEncoding.base64().encode(blockIdBytes);
            blockIds.add(blockId);
            this.client.putBlock(container, blobName, blockId, block);
        }
        Preconditions.checkState((bytesWritten == length ? 1 : 0) != 0, (String)"Wrote %s bytes, but we wanted to write %s bytes", (Object[])new Object[]{bytesWritten, length});
        return this.client.putBlockList(container, blobName, blockIds);
    }
}

