/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="CloudSigmaLasVegasTemplateBuilderLiveTest")
public class CloudSigmaLasVegasTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public CloudSigmaLasVegasTemplateBuilderLiveTest() {
        this.provider = "cloudsigma-lvs";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return ImmutableSet.of((Object)"11.04", (Object)"10.10").contains((Object)input.version) && input.is64Bit || input.version.equals("11.10") && !input.is64Bit || input.version.equals("") || input.version.equals("10.04") || input.version.equals("12.04");
                    }
                    case SOLARIS: {
                        return (input.version.equals("") || input.version.equals("10")) && input.is64Bit;
                    }
                    case DEBIAN: {
                        return input.version.equals("") || input.version.equals("5.0") && !input.is64Bit || input.version.equals("6.0") && input.is64Bit;
                    }
                    case CENTOS: {
                        return (input.version.equals("") || input.version.equals("5.5") || input.version.equals("5.7") || input.version.equals("6.0")) && input.is64Bit;
                    }
                    case WINDOWS: {
                        return input.version.equals("2008") || input.version.equals("2003") || input.version.equals("");
                    }
                }
                return false;
            }
        });
    }

    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"11.04");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((String)defaultTemplate.getImage().getId(), (String)"6aab1938-71b3-4252-ac1c-a3cb17c284ab");
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)defaultTemplate.getImage().getDefaultCredentials().identity, (String)"root");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"US-NV");
    }
}

