/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.compute.options.CloudSigmaTemplateOptions;
import org.jclouds.cloudsigma.domain.AffinityType;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.DriveType;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.cloudsigma.util.Servers;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class CloudSigmaComputeServiceAdapter
implements ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location> {
    private static final Predicate<DriveInfo> PREINSTALLED_DISK = Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<DriveInfo>(){

        public boolean apply(DriveInfo drive) {
            return drive.getType().equals((Object)DriveType.DISK) && drive.getDriveType().contains("preinstalled");
        }
    });
    private final CloudSigmaClient client;
    private final Predicate<DriveInfo> driveNotClaimed;
    private final String defaultVncPassword;
    private final LoadingCache<String, DriveInfo> cache;
    private final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    public CloudSigmaComputeServiceAdapter(CloudSigmaClient client, Predicate<DriveInfo> driveNotClaimed, @Named(value="jclouds.cloudsigma.vnc-password") String defaultVncPassword, LoadingCache<String, DriveInfo> cache, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.client = (CloudSigmaClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.driveNotClaimed = (Predicate)Preconditions.checkNotNull(driveNotClaimed, (Object)"driveNotClaimed");
        this.defaultVncPassword = (String)Preconditions.checkNotNull((Object)defaultVncPassword, (Object)"defaultVncPassword");
        Preconditions.checkArgument((defaultVncPassword.length() <= 8 ? 1 : 0) != 0, (Object)"vnc passwords should be less that 8 characters!");
        this.cache = (LoadingCache)Preconditions.checkNotNull(cache, (Object)"cache");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInfo> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        long bootSize = (long)(((Volume)template.getHardware().getVolumes().get(0)).getSize().floatValue() * 1024.0f * 1024.0f * 1024.0f);
        AffinityType affinityType = AffinityType.HDD;
        if (template.getOptions() instanceof CloudSigmaTemplateOptions) {
            CloudSigmaTemplateOptions options = (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(template.getOptions());
            affinityType = options.getDiskDriveAffinity();
        }
        this.logger.debug(">> imaging boot drive source(%s) bytes(%d) affinityType(%s)", new Object[]{template.getImage().getId(), bootSize, affinityType});
        DriveInfo drive = this.client.cloneDrive(template.getImage().getId(), template.getImage().getId(), new CloneDriveOptions().size(bootSize).affinity(affinityType));
        boolean success = this.driveNotClaimed.apply((Object)drive);
        this.logger.debug("<< image(%s) complete(%s)", new Object[]{drive.getUuid(), success});
        if (!success) {
            this.client.destroyDrive(drive.getUuid());
            throw new IllegalStateException("could not image drive in time!");
        }
        Server toCreate = Servers.small(name, drive.getUuid(), this.defaultVncPassword).mem(template.getHardware().getRam()).cpu((int)((Processor)template.getHardware().getProcessors().get(0)).getSpeed()).build();
        this.logger.debug(">> creating server", new Object[0]);
        ServerInfo from = this.client.createServer(toCreate);
        this.logger.debug("<< created server(%s)", new Object[]{from.getUuid()});
        this.logger.debug(">> starting server(%s)", new Object[]{from.getUuid()});
        this.client.startServer(from.getUuid());
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)from, from.getUuid(), LoginCredentials.builder().password(this.defaultVncPassword).authenticateSudo(true).build());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        ImmutableSet.Builder hardware = ImmutableSet.builder();
        for (double cpu : new double[]{1000.0, 5000.0, 10000.0, 20000.0}) {
            for (int ram : new int[]{512, 1024, 4096, 16384, 32768}) {
                final float size = (float)cpu / 100.0f;
                String id = String.format("cpu=%f,ram=%s,disk=%f", cpu, ram, Float.valueOf(size));
                hardware.add((Object)new HardwareBuilder().supportsImage((Predicate)new Predicate<Image>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean apply(Image input) {
                        String toParse = (String)input.getUserMetadata().get("size");
                        if (toParse == null) return false;
                        Float f = new Float(toParse);
                        if (!(f.floatValue() <= size)) return false;
                        return true;
                    }

                    public String toString() {
                        return "sizeLessThanOrEqual(" + size + ")";
                    }
                }).ids(id).ram(ram).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, cpu))).hypervisor("kvm").volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(size), true, true))).build());
            }
        }
        return hardware.build();
    }

    public Iterable<DriveInfo> listImages() {
        return FluentIterable.from((Iterable)FutureIterables.transformParallel(this.client.listStandardDrives(), (Function)new Function<String, ListenableFuture<? extends DriveInfo>>(){

            public ListenableFuture<DriveInfo> apply(String input) {
                try {
                    return Futures.immediateFuture((Object)CloudSigmaComputeServiceAdapter.this.cache.getUnchecked((Object)input));
                }
                catch (CacheLoader.InvalidCacheLoadException e) {
                    CloudSigmaComputeServiceAdapter.this.logger.debug("drive %s not found", new Object[]{input});
                }
                catch (UncheckedExecutionException e) {
                    CloudSigmaComputeServiceAdapter.this.logger.warn((Throwable)e, "error finding drive %s: %s", new Object[]{input, e.getMessage()});
                }
                return Futures.immediateFuture(null);
            }

            public String toString() {
                return "seedDriveCache()";
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"drives")).filter(PREINSTALLED_DISK);
    }

    public Iterable<ServerInfo> listNodes() {
        return this.client.listServerInfo();
    }

    public Iterable<ServerInfo> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<ServerInfo>(){

            public boolean apply(ServerInfo server) {
                return Iterables.contains((Iterable)ids, (Object)server.getUuid());
            }
        });
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public ServerInfo getNode(String id) {
        return this.client.getServerInfo(id);
    }

    public DriveInfo getImage(String id) {
        return this.client.getDriveInfo(id);
    }

    public void destroyNode(String id) {
        ServerInfo server = this.getNode(id);
        if (server != null) {
            this.client.stopServer(id);
            this.client.destroyServer(id);
            for (Device dev : server.getDevices().values()) {
                this.client.destroyDrive(dev.getDriveUuid());
            }
        }
    }

    public void rebootNode(String id) {
        this.client.resetServer(id);
    }

    public void resumeNode(String id) {
        this.client.startServer(id);
    }

    public void suspendNode(String id) {
        this.client.stopServer(id);
    }
}

