/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.functions.BaseDriveToMap;

@Singleton
public class DriveDataToMap
implements Function<DriveData, Map<String, String>> {
    private final BaseDriveToMap baseDriveToMap;

    @Inject
    public DriveDataToMap(BaseDriveToMap baseDriveToMap) {
        this.baseDriveToMap = baseDriveToMap;
    }

    public Map<String, String> apply(DriveData from) {
        return DriveDataToMap.renameKey(this.baseDriveToMap.apply(from), "use", "use");
    }

    @VisibleForTesting
    static <V> Map<String, V> renameKey(Map<String, V> in, String k1, String k2) {
        if (((Map)Preconditions.checkNotNull(in, (Object)"input map")).containsKey(Preconditions.checkNotNull((Object)k1, (Object)"old key"))) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(Maps.filterKeys(in, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)k1))));
            V tags = in.get(k1);
            builder.put(Preconditions.checkNotNull((Object)k2, (Object)"new key"), tags);
            in = builder.build();
        }
        return in;
    }
}

