/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.collect.ImmutableList;
import java.util.logging.Logger;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.GeoRegionGroup;
import org.jclouds.dynect.v3.domain.RecordSet;
import org.jclouds.dynect.v3.features.GeoRegionGroupApi;
import org.jclouds.dynect.v3.features.GeoServiceApi;
import org.jclouds.dynect.v3.internal.BaseDynECTApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GeoRegionGroupApiLiveTest")
public class GeoRegionGroupApiLiveTest
extends BaseDynECTApiLiveTest {
    @Test
    protected void testListAndGetGeoRegionGroups() {
        for (String service : this.geoApi().list()) {
            GeoRegionGroupApi api = this.api(service);
            ImmutableList groups = api.list().toList();
            Logger.getAnonymousLogger().info("geo service: " + service + " group count: " + groups.size());
            for (String group : groups) {
                GeoRegionGroup groupDetail = api.get(group);
                Assert.assertNotNull((Object)groupDetail.getServiceName().get(), (String)("ServiceName cannot be null " + groupDetail));
                GeoRegionGroupApiLiveTest.checkGeoRegionGroup(groupDetail);
            }
        }
    }

    static void checkGeoRegionGroup(GeoRegionGroup group) {
        Assert.assertNotNull((Object)group.getName(), (String)("Name cannot be null " + group));
        Assert.assertTrue((group.getCountries().size() > 0 ? 1 : 0) != 0, (String)("countries must be assigned " + group));
        Assert.assertTrue((group.getRecordSets().size() > 0 ? 1 : 0) != 0, (String)("RecordSets must be assigned " + group));
        for (RecordSet recordSet : group.getRecordSets()) {
            GeoRegionGroupApiLiveTest.checkRecordSet(recordSet);
        }
    }

    static void checkRecordSet(RecordSet rset) {
        Assert.assertNotNull((Object)rset.getType(), (String)("Type cannot be null " + rset));
        Assert.assertTrue((rset.getTTL() >= 0 ? 1 : 0) != 0, (String)("TTL cannot be negative " + rset));
        for (RecordSet.Value value : rset) {
            GeoRegionGroupApiLiveTest.checkValue(value);
        }
    }

    static void checkValue(RecordSet.Value value) {
        Assert.assertNotNull((Object)value.getLabel(), (String)("Label cannot be null " + value));
        Assert.assertNotNull((Object)value.getWeight(), (String)("Weight cannot be null " + value));
        Assert.assertTrue((value.getRData().size() > 0 ? 1 : 0) != 0, (String)("RData entries should be present: " + value));
    }

    protected GeoRegionGroupApi api(String serviceName) {
        return ((DynECTApi)this.api).getGeoRegionGroupApiForService(serviceName);
    }

    protected GeoServiceApi geoApi() {
        return ((DynECTApi)this.api).getGeoServiceApi();
    }
}

