/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.collect.ImmutableList;
import java.util.logging.Logger;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.GeoRegionGroup;
import org.jclouds.dynect.v3.domain.GeoService;
import org.jclouds.dynect.v3.features.GeoRegionGroupApiLiveTest;
import org.jclouds.dynect.v3.features.GeoServiceApi;
import org.jclouds.dynect.v3.internal.BaseDynECTApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GeoServiceApiLiveTest")
public class GeoServiceApiLiveTest
extends BaseDynECTApiLiveTest {
    @Test
    protected void testListAndGetGeoServices() {
        ImmutableList geos = this.api().list().toList();
        Logger.getAnonymousLogger().info("geo services: " + geos.size());
        for (String fqdn : geos) {
            GeoService geo = this.api().get(fqdn);
            GeoServiceApiLiveTest.checkGeoService(geo);
        }
    }

    static void checkGeoService(GeoService service) {
        Assert.assertNotNull((Object)service.getName(), (String)("Name cannot be null " + service));
        Assert.assertTrue((service.getTTL() >= 0 ? 1 : 0) != 0, (String)("TTL cannot be negative " + service));
        Assert.assertTrue((service.getNodes().size() > 0 ? 1 : 0) != 0, (String)("Nodes must be assigned " + service));
        Assert.assertTrue((service.getGroups().size() > 0 ? 1 : 0) != 0, (String)("Groups must be assigned " + service));
        for (GeoRegionGroup group : service.getGroups()) {
            GeoRegionGroupApiLiveTest.checkGeoRegionGroup(group);
        }
    }

    protected GeoServiceApi api() {
        return ((DynECTApi)this.api).getGeoServiceApi();
    }
}

