/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.CreateRecord;
import org.jclouds.dynect.v3.domain.Job;
import org.jclouds.dynect.v3.domain.RecordId;
import org.jclouds.dynect.v3.domain.rdata.AData;
import org.jclouds.dynect.v3.internal.BaseDynECTApiExpectTest;
import org.jclouds.dynect.v3.parse.GetAAAARecordResponseTest;
import org.jclouds.dynect.v3.parse.GetARecordResponseTest;
import org.jclouds.dynect.v3.parse.GetCNAMERecordResponseTest;
import org.jclouds.dynect.v3.parse.GetMXRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetNSRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetPTRRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetSOARecordResponseTest;
import org.jclouds.dynect.v3.parse.GetSPFRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetSRVRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetSSHFPRecordResponseTest;
import org.jclouds.dynect.v3.parse.GetTXTRecordResponseTest;
import org.jclouds.dynect.v3.parse.ListRecordsResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RecordApiExpectTest")
public class RecordApiExpectTest
extends BaseDynECTApiExpectTest {
    HttpRequest getSOA;
    HttpResponse soaResponse;
    RecordId soaId;
    HttpRequest getAAAA;
    HttpResponse aaaaResponse;
    RecordId aaaaId;
    HttpRequest getA;
    HttpResponse aResponse;
    RecordId aId;
    HttpRequest getCNAME;
    HttpResponse cnameResponse;
    RecordId cnameId;
    HttpRequest getMX;
    HttpResponse mxResponse;
    RecordId mxId;
    HttpRequest getNS;
    HttpResponse nsResponse;
    RecordId nsId;
    HttpRequest getPTR;
    HttpResponse ptrResponse;
    RecordId ptrId;
    HttpRequest getSPF;
    HttpResponse spfResponse;
    RecordId spfId;
    HttpRequest getSRV;
    HttpResponse srvResponse;
    RecordId srvId;
    HttpRequest getSSHFP;
    HttpResponse sshfpResponse;
    RecordId sshfpId;
    HttpRequest getTXT;
    HttpResponse txtResponse;
    RecordId txtId;
    HttpRequest list;
    HttpResponse listResponse;
    HttpRequest listByFQDN;
    HttpRequest listByFQDNAndType;
    HttpRequest create;
    HttpResponse createResponse;
    HttpRequest delete;
    HttpResponse deleteResponse;
    RecordId id;

    public RecordApiExpectTest() {
        this.getSOA = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/SOARecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.soaResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_soa.json", "application/json"))).build();
        this.soaId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("SOA").id(50976579L).build();
        this.getAAAA = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/AAAARecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.aaaaResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_aaaa.json", "application/json"))).build();
        this.aaaaId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("AAAA").id(50976579L).build();
        this.getA = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/ARecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.aResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_a.json", "application/json"))).build();
        this.aId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("A").id(50976579L).build();
        this.getCNAME = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/CNAMERecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.cnameResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_cname.json", "application/json"))).build();
        this.cnameId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("CNAME").id(50976579L).build();
        this.getMX = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/MXRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.mxResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_mx.json", "application/json"))).build();
        this.mxId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("MX").id(50976579L).build();
        this.getNS = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/NSRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.nsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_ns.json", "application/json"))).build();
        this.nsId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("NS").id(50976579L).build();
        this.getPTR = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/PTRRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.ptrResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_ptr.json", "application/json"))).build();
        this.ptrId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("PTR").id(50976579L).build();
        this.getSPF = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/SPFRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.spfResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_spf.json", "application/json"))).build();
        this.spfId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("SPF").id(50976579L).build();
        this.getSRV = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/SRVRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.srvResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_srv.json", "application/json"))).build();
        this.srvId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("SRV").id(50976579L).build();
        this.getSSHFP = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/SSHFPRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.sshfpResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_sshfp.json", "application/json"))).build();
        this.sshfpId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("SSHFP").id(50976579L).build();
        this.getTXT = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/TXTRecord/jclouds.org/jclouds.org/50976579").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.txtResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_record_txt.json", "application/json"))).build();
        this.txtId = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("jclouds.org").type("TXT").id(50976579L).build();
        this.list = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/AllRecord/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/list_records.json", "application/json"))).build();
        this.listByFQDN = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/AllRecord/jclouds.org/www.foo.com").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.listByFQDNAndType = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/ARecord/jclouds.org/www.foo.com").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.create = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api2.dynect.net/REST/ARecord/jclouds.org/www.jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).payload(RecordApiExpectTest.stringPayload("{\"rdata\":{\"address\":\"1.1.1.1\"},\"ttl\":86400}"))).build();
        this.createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/new_record.json", "application/json"))).build();
        this.delete = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://api2.dynect.net/REST/ARecord/jclouds.org/www.jclouds.org/285372440").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/delete_record.json", "application/json"))).build();
        this.id = RecordId.recordIdBuilder().zone("jclouds.org").fqdn("www.jclouds.org").type("A").id(285372440L).build();
    }

    public void testGetWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSOA, this.soaResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").get(this.soaId).toString(), (String)new GetRecordResponseTest().expected().toString());
    }

    public void testGetWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSOA, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").get(this.soaId));
    }

    public void testGetAAAAWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getAAAA, this.aaaaResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getAAAA(this.aaaaId.getFQDN(), this.aaaaId.getId()).toString(), (String)new GetAAAARecordResponseTest().expected().toString());
    }

    public void testGetAAAAWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getAAAA, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getAAAA(this.aaaaId.getFQDN(), this.aaaaId.getId()));
    }

    public void testGetAWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getA, this.aResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getA(this.aId.getFQDN(), this.aId.getId()).toString(), (String)new GetARecordResponseTest().expected().toString());
    }

    public void testGetAWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getA, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getA(this.aId.getFQDN(), this.aId.getId()));
    }

    public void testGetCNAMEWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getCNAME, this.cnameResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getCNAME(this.cnameId.getFQDN(), this.cnameId.getId()).toString(), (String)new GetCNAMERecordResponseTest().expected().toString());
    }

    public void testGetCNAMEWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getCNAME, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getCNAME(this.cnameId.getFQDN(), this.cnameId.getId()));
    }

    public void testGetMXWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getMX, this.mxResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getMX(this.mxId.getFQDN(), this.mxId.getId()).toString(), (String)new GetMXRecordResponseTest().expected().toString());
    }

    public void testGetMXWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getMX, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getMX(this.mxId.getFQDN(), this.mxId.getId()));
    }

    public void testGetNSWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getNS, this.nsResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getNS(this.nsId.getFQDN(), this.nsId.getId()).toString(), (String)new GetNSRecordResponseTest().expected().toString());
    }

    public void testGetNSWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getNS, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getNS(this.nsId.getFQDN(), this.nsId.getId()));
    }

    public void testGetPTRWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getPTR, this.ptrResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getPTR(this.ptrId.getFQDN(), this.ptrId.getId()).toString(), (String)new GetPTRRecordResponseTest().expected().toString());
    }

    public void testGetPTRWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getPTR, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getPTR(this.ptrId.getFQDN(), this.ptrId.getId()));
    }

    public void testGetSOAWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSOA, this.soaResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getSOA(this.soaId.getFQDN(), this.soaId.getId()).toString(), (String)new GetSOARecordResponseTest().expected().toString());
    }

    public void testGetSOAWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSOA, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getSOA(this.soaId.getFQDN(), this.soaId.getId()));
    }

    public void testGetSPFWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSPF, this.spfResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getSPF(this.spfId.getFQDN(), this.spfId.getId()).toString(), (String)new GetSPFRecordResponseTest().expected().toString());
    }

    public void testGetSRVWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSRV, this.srvResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getSRV(this.srvId.getFQDN(), this.srvId.getId()).toString(), (String)new GetSRVRecordResponseTest().expected().toString());
    }

    public void testGetSSHFPWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getSSHFP, this.sshfpResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getSSHFP(this.sshfpId.getFQDN(), this.sshfpId.getId()).toString(), (String)new GetSSHFPRecordResponseTest().expected().toString());
    }

    public void testGetTXTWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getTXT, this.txtResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").getTXT(this.txtId.getFQDN(), this.txtId.getId()).toString(), (String)new GetTXTRecordResponseTest().expected().toString());
    }

    public void testGetTXTWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.getTXT, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").getTXT(this.txtId.getFQDN(), this.txtId.getId()));
    }

    public void testListWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.list, this.listResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").list().toString(), (String)new ListRecordsResponseTest().expected().toString());
    }

    public void testListByFQDNWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.listByFQDN, this.listResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").listByFQDN("www.foo.com").toString(), (String)new ListRecordsResponseTest().expected().toString());
    }

    public void testListByFQDNWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.listByFQDN, this.notFound);
        Assert.assertTrue((boolean)fail.getRecordApiForZone("jclouds.org").listByFQDN("www.foo.com").isEmpty());
    }

    public void testListByFQDNAndTypeWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.listByFQDNAndType, this.listResponse);
        Assert.assertEquals((String)success.getRecordApiForZone("jclouds.org").listByFQDNAndType("www.foo.com", "A").toString(), (String)new ListRecordsResponseTest().expected().toString());
    }

    public void testListByFQDNAndTypeWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.listByFQDNAndType, this.notFound);
        Assert.assertTrue((boolean)fail.getRecordApiForZone("jclouds.org").listByFQDNAndType("www.foo.com", "A").isEmpty());
    }

    public void testCreateWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.create, this.createResponse);
        CreateRecord record = CreateRecord.builder().fqdn("www.jclouds.org").type("A").ttl(86400).rdata((Map)AData.a((String)"1.1.1.1")).build();
        Assert.assertEquals((Object)success.getRecordApiForZone("jclouds.org").scheduleCreate(record), (Object)Job.success((long)285372440L));
    }

    public void testDeleteWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.delete, this.deleteResponse);
        Assert.assertEquals((Object)success.getRecordApiForZone("jclouds.org").scheduleDelete(this.id), (Object)Job.success((long)285372457L));
    }

    public void testDeleteWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.delete, this.notFound);
        Assert.assertNull((Object)fail.getRecordApiForZone("jclouds.org").scheduleDelete(this.id));
    }
}

