/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.base.Preconditions;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.Session;
import org.jclouds.dynect.v3.domain.SessionCredentials;
import org.jclouds.dynect.v3.features.SessionApi;
import org.jclouds.dynect.v3.internal.BaseDynECTApiLiveTest;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="SessionApiLiveTest")
public class SessionApiLiveTest
extends BaseDynECTApiLiveTest {
    private Session session;

    private void checkSession(Session zone) {
        Preconditions.checkNotNull((Object)zone.getToken(), (Object)"Token cannot be null for a Session.");
        Preconditions.checkNotNull((Object)zone.getVersion(), (Object)"Version cannot be null for a Session.");
    }

    @Test
    protected void testCreateSession() {
        SessionCredentials credentials = SessionCredentials.builder().customerName(this.identity.substring(0, this.identity.indexOf(58))).userName(this.identity.substring(this.identity.indexOf(58) + 1)).password(this.credential).build();
        this.session = this.api().login(credentials);
        this.checkSession(this.session);
    }

    protected SessionApi api() {
        return ((DynECTApi)this.api).getSessionApi();
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.session != null) {
            this.api().logout(this.session.getToken());
        }
        super.tearDown();
    }
}

