/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.options;

import org.jclouds.glesys.compute.options.GleSYSTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GleSYSTemplateOptionsTest")
public class GleSYSTemplateOptionsTest {
    @Test
    public void testAs() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions();
        Assert.assertEquals((Object)options.as(GleSYSTemplateOptions.class), (Object)options);
    }

    @Test
    public void testDefaultip() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions();
        Assert.assertEquals((String)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getIp(), (String)"any");
    }

    @Test
    public void testip() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions().ip("1.1.1.1");
        Assert.assertEquals((String)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getIp(), (String)"1.1.1.1");
    }

    @Test
    public void testipStatic() {
        GleSYSTemplateOptions options = GleSYSTemplateOptions.Builder.ip((String)"1.1.1.1");
        Assert.assertEquals((String)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getIp(), (String)"1.1.1.1");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIpThrowsNPE() {
        new GleSYSTemplateOptions().ip(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidIpThrowsIllegalArgument() {
        new GleSYSTemplateOptions().ip("1.1.1");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testipIsInvalidThrowsIllegalArgument() {
        new GleSYSTemplateOptions().ip("foo");
    }

    @Test
    public void testDefaultRootPassword() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions();
        Assert.assertEquals((String)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getRootPassword(), null);
    }

    @Test
    public void testRootPassword() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions().rootPassword("secret");
        Assert.assertEquals((String)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getRootPassword(), (String)"secret");
    }

    @Test
    public void testRootPasswordStatic() {
        GleSYSTemplateOptions options = GleSYSTemplateOptions.Builder.rootPassword((String)"secret");
        Assert.assertEquals((String)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getRootPassword(), (String)"secret");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullRootPasswordThrowsNPE() {
        new GleSYSTemplateOptions().rootPassword(null);
    }

    @Test
    public void testDefaultTranferGB() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions();
        Assert.assertEquals((int)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getTransferGB(), (int)50);
    }

    @Test
    public void testTransferGB() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions().transferGB(75);
        Assert.assertEquals((int)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getTransferGB(), (int)75);
    }

    @Test
    public void testTransferGBStatic() {
        GleSYSTemplateOptions options = GleSYSTemplateOptions.Builder.transferGB((int)75);
        Assert.assertEquals((int)((GleSYSTemplateOptions)options.as(GleSYSTemplateOptions.class)).getTransferGB(), (int)75);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNegativeTransferGBThrowsException() {
        new GleSYSTemplateOptions().transferGB(-1);
    }

    @Test
    public void testClone() {
        GleSYSTemplateOptions clone = GleSYSTemplateOptions.Builder.transferGB((int)75).rootPassword("root").ip("1.1.1.1").clone();
        Assert.assertEquals((int)clone.getTransferGB(), (int)75);
        Assert.assertEquals((String)clone.getRootPassword(), (String)"root");
        Assert.assertEquals((String)clone.getIp(), (String)"1.1.1.1");
    }
}

