/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.IpDetails;
import org.jclouds.glesys.features.IpApi;
import org.jclouds.glesys.internal.BaseGleSYSApiWithAServerLiveTest;
import org.jclouds.glesys.options.ListIpOptions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="IpApiLiveTest", singleThreaded=true)
public class IpApiLiveTest
extends BaseGleSYSApiWithAServerLiveTest {
    private IpApi ipApi;
    private IpDetails reservedIp;

    public IpApiLiveTest() {
        this.hostName = this.hostName + "-ip";
    }

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.ipApi = ((GleSYSApi)this.api).getIpApi();
    }

    @Override
    @AfterClass(groups={"integration", "live"})
    public void tearDown() {
        if (this.reservedIp != null) {
            this.ipApi.release(this.reservedIp.getAddress());
        }
        super.tearDown();
    }

    @Test
    public void testListFree() throws Exception {
        FluentIterable freeIps = this.ipApi.listFree(4, "Falkenberg", "Xen");
        Assert.assertFalse((boolean)freeIps.isEmpty());
    }

    @Test
    public void reserveIp() throws Exception {
        FluentIterable openVzIps = this.ipApi.listFree(4, "Falkenberg", "OpenVZ");
        Assert.assertFalse((boolean)openVzIps.isEmpty());
        this.reservedIp = this.ipApi.take((String)Iterables.get((Iterable)openVzIps, (int)0));
        Assert.assertTrue((boolean)this.reservedIp.isReserved());
        this.checkOpenVZDefailsInFalkenberg(this.reservedIp);
    }

    @Test(dependsOnMethods={"reserveIp"})
    public void reserveAndReleaseIp() throws Exception {
        IpDetails details = this.ipApi.release(this.reservedIp.getAddress());
        Assert.assertEquals((String)details.getAddress(), (String)this.reservedIp.getAddress());
        Assert.assertFalse((boolean)details.isReserved());
        this.reserveIp();
    }

    @Test(dependsOnMethods={"reserveIp"})
    public void testList() throws Exception {
        FluentIterable ownIps = this.ipApi.list(new ListIpOptions[0]);
        Assert.assertTrue((boolean)ownIps.contains((Object)this.reservedIp));
        ownIps = this.ipApi.list(new ListIpOptions[]{ListIpOptions.Builder.datacenter((String)this.reservedIp.getDatacenter())});
        Assert.assertTrue((boolean)ownIps.contains((Object)this.reservedIp));
        ownIps = this.ipApi.list(new ListIpOptions[]{ListIpOptions.Builder.platform((String)this.reservedIp.getPlatform())});
        Assert.assertTrue((boolean)ownIps.contains((Object)this.reservedIp));
        ownIps = this.ipApi.list(new ListIpOptions[]{ListIpOptions.Builder.ipVersion((int)this.reservedIp.getVersion())});
        Assert.assertTrue((boolean)ownIps.contains((Object)this.reservedIp));
        ownIps = this.ipApi.list(new ListIpOptions[]{ListIpOptions.Builder.datacenter((String)this.reservedIp.getDatacenter()), ListIpOptions.Builder.platform((String)this.reservedIp.getPlatform()), ListIpOptions.Builder.ipVersion((int)this.reservedIp.getVersion())});
        Assert.assertTrue((boolean)ownIps.contains((Object)this.reservedIp));
        ownIps = this.ipApi.list(new ListIpOptions[]{ListIpOptions.Builder.serverId((String)"xmthisisnotaserverid")});
        Assert.assertTrue((boolean)ownIps.isEmpty());
    }

    private void checkOpenVZDefailsInFalkenberg(IpDetails ipDetails) {
        Assert.assertEquals((String)ipDetails.getDatacenter(), (String)"Falkenberg");
        Assert.assertEquals((String)ipDetails.getPlatform(), (String)"OpenVZ");
        Assert.assertEquals((int)ipDetails.getVersion(), (int)4);
        Assert.assertFalse((boolean)ipDetails.getPtr().isEmpty());
        Assert.assertFalse((boolean)ipDetails.getNameServers().isEmpty());
    }

    @Test
    public void testGetOpenVZDetails() throws Exception {
        FluentIterable openVzIps = this.ipApi.listFree(4, "Falkenberg", "OpenVZ");
        Assert.assertFalse((boolean)openVzIps.isEmpty());
        String openVzIp = (String)openVzIps.iterator().next();
        IpDetails ipDetails = this.ipApi.get(openVzIp);
        this.checkOpenVZDefailsInFalkenberg(ipDetails);
        Assert.assertEquals((String)ipDetails.getAddress(), (String)openVzIp);
    }

    @Test
    public void testGetXenDetails() throws Exception {
        FluentIterable xenVzIps = this.ipApi.listFree(4, "Falkenberg", "Xen");
        Assert.assertFalse((boolean)xenVzIps.isEmpty());
        String xenIp = (String)xenVzIps.iterator().next();
        IpDetails ipDetails = this.ipApi.get(xenIp);
        Assert.assertEquals((String)ipDetails.getDatacenter(), (String)"Falkenberg");
        Assert.assertEquals((String)ipDetails.getPlatform(), (String)"Xen");
        Assert.assertEquals((int)ipDetails.getVersion(), (int)4);
        Assert.assertEquals((String)ipDetails.getAddress(), (String)xenIp);
        Assert.assertFalse((boolean)ipDetails.getPtr().isEmpty());
        Assert.assertNotNull((Object)ipDetails.getBroadcast());
        Assert.assertNotNull((Object)ipDetails.getGateway());
        Assert.assertNotNull((Object)ipDetails.getNetmask());
        Assert.assertFalse((boolean)ipDetails.getNameServers().isEmpty());
    }

    @Test(dependsOnMethods={"reserveIp"})
    public void testPtrSetReset() throws Exception {
        IpDetails original = this.reservedIp;
        IpDetails modified = this.ipApi.setPtr(this.reservedIp.getAddress(), "wibble.");
        IpDetails modified2 = this.ipApi.get(this.reservedIp.getAddress());
        Assert.assertEquals((String)modified.getPtr(), (String)"wibble.");
        Assert.assertEquals((Object)modified2, (Object)modified);
        this.reservedIp = this.ipApi.resetPtr(this.reservedIp.getAddress());
        Assert.assertEquals((Object)this.reservedIp, (Object)original);
    }

    @Test(dependsOnMethods={"reserveIp"})
    public void testAddRemove() throws Exception {
        IpDetails added = this.ipApi.addToServer(this.reservedIp.getAddress(), this.serverId);
        Assert.assertEquals((String)added.getAddress(), (String)this.reservedIp.getAddress());
        Assert.assertEquals((String)added.getPtr(), (String)this.reservedIp.getPtr());
        Assert.assertEquals((String)added.getServerId(), (String)this.serverId);
        IpDetails again = this.ipApi.get(this.reservedIp.getAddress());
        Assert.assertEquals((Object)again, (Object)added);
        IpDetails removed = this.ipApi.removeFromServer(this.reservedIp.getAddress(), this.serverId);
        Assert.assertEquals((Object)removed, (Object)added.toBuilder().serverId(null).build());
        Assert.assertEquals((Object)removed, (Object)this.reservedIp);
        HashSet openVzIps = Sets.newHashSet((Iterable)this.ipApi.listFree(4, "Falkenberg", "OpenVZ"));
        openVzIps.remove(this.reservedIp.getAddress());
        Assert.assertFalse((boolean)openVzIps.isEmpty());
        added = this.ipApi.addToServer(this.reservedIp.getAddress(), this.serverId);
        Assert.assertEquals((String)added.getServerId(), (String)this.serverId);
        removed = this.ipApi.removeFromServerAndRelease(this.reservedIp.getAddress(), this.serverId);
        Assert.assertNull((Object)removed.getServerId());
        Assert.assertFalse((boolean)removed.isReserved());
        this.reserveIp();
    }
}

