/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.glesys.domain.ServerSpec;
import org.jclouds.location.predicates.LocationPredicates;

@Singleton
public class ServerSpecToHardware
implements Function<ServerSpec, Hardware> {
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    ServerSpecToHardware(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    public Hardware apply(ServerSpec spec) {
        Location location = (Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)spec.getDatacenter())).orNull();
        assert (location != null) : String.format("no location matched ServerSpec %s", spec);
        return new HardwareBuilder().ids(spec.toString()).ram(spec.getMemorySizeMB()).processors((Iterable)ImmutableList.of((Object)new Processor((double)spec.getCpuCores(), 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(spec.getDiskSizeGB()), true, true))).hypervisor(spec.getPlatform()).location(location).supportsImage(ImagePredicates.idEquals((String)spec.getTemplateName())).build();
    }
}

