/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.glesys.domain.EmailQuota;
import org.jclouds.glesys.domain.GleSYSBoolean;
import org.jclouds.javax.annotation.Nullable;

public class EmailAccount {
    private final String account;
    private final EmailQuota quota;
    private final int antispamLevel;
    private final boolean antiVirus;
    private final boolean autoRespond;
    private final String autoRespondMessage;
    private final boolean autoRespondSaveEmail;
    private final Date created;
    private final Date modified;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEmailAccount(this);
    }

    @ConstructorProperties(value={"emailaccount", "quota", "antispamlevel", "antivirus", "autorespond", "autorespondmessage", "autorespondsaveemail", "created", "modified"})
    protected EmailAccount(String account, EmailQuota quota, int antispamLevel, GleSYSBoolean antiVirus, GleSYSBoolean autoRespond, @Nullable String autoRespondMessage, GleSYSBoolean autoRespondSaveEmail, Date created, @Nullable Date modified) {
        this.account = (String)Preconditions.checkNotNull((Object)account, (Object)"account");
        this.quota = (EmailQuota)Preconditions.checkNotNull((Object)quota, (Object)"quota");
        this.antispamLevel = antispamLevel;
        this.antiVirus = ((GleSYSBoolean)Preconditions.checkNotNull((Object)antiVirus, (Object)"antiVirus")).getValue();
        this.autoRespond = ((GleSYSBoolean)Preconditions.checkNotNull((Object)autoRespond, (Object)"autoRespond")).getValue();
        this.autoRespondMessage = autoRespondMessage;
        this.autoRespondSaveEmail = ((GleSYSBoolean)Preconditions.checkNotNull((Object)autoRespondSaveEmail, (Object)"autoRespondSaveEmail")).getValue();
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created");
        this.modified = modified;
    }

    public String getAccount() {
        return this.account;
    }

    public EmailQuota getQuota() {
        return this.quota;
    }

    public int getAntispamLevel() {
        return this.antispamLevel;
    }

    public boolean isAntiVirus() {
        return this.antiVirus;
    }

    public boolean isAutoRespond() {
        return this.autoRespond;
    }

    @Nullable
    public String getAutoRespondMessage() {
        return this.autoRespondMessage;
    }

    public boolean isAutoRespondSaveEmail() {
        return this.autoRespondSaveEmail;
    }

    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public Date getModified() {
        return this.modified;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailAccount that = (EmailAccount)EmailAccount.class.cast(obj);
        return Objects.equal((Object)this.account, (Object)that.account);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("account", (Object)this.account).add("quota", (Object)this.quota).add("antispamLevel", this.antispamLevel).add("antiVirus", this.antiVirus).add("autoRespond", this.autoRespond).add("autoRespondMessage", (Object)this.autoRespondMessage).add("autoRespondSaveEmail", this.autoRespondSaveEmail).add("created", (Object)this.created).add("modified", (Object)this.modified);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String account;
        protected EmailQuota quota;
        protected int antispamLevel;
        protected boolean antiVirus;
        protected boolean autoRespond;
        protected String autoRespondMessage;
        protected boolean autoRespondSaveEmail;
        protected Date created;
        protected Date modified;

        protected abstract T self();

        public T account(String account) {
            this.account = (String)Preconditions.checkNotNull((Object)account, (Object)"account");
            return this.self();
        }

        public T quota(EmailQuota quota) {
            this.quota = (EmailQuota)Preconditions.checkNotNull((Object)quota, (Object)"quota");
            return this.self();
        }

        public T antispamLevel(int antispamLevel) {
            this.antispamLevel = antispamLevel;
            return this.self();
        }

        public T antiVirus(boolean antiVirus) {
            this.antiVirus = antiVirus;
            return this.self();
        }

        public T autoRespond(boolean autoRespond) {
            this.autoRespond = autoRespond;
            return this.self();
        }

        public T autoRespondMessage(String autoRespondMessage) {
            this.autoRespondMessage = (String)Preconditions.checkNotNull((Object)autoRespondMessage, (Object)"autoRespondMessage");
            return this.self();
        }

        public T autoRespondSaveEmail(boolean autoRespondSaveEmail) {
            this.autoRespondSaveEmail = autoRespondSaveEmail;
            return this.self();
        }

        public T created(Date created) {
            this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created");
            return this.self();
        }

        public T modified(Date modified) {
            this.modified = (Date)Preconditions.checkNotNull((Object)modified, (Object)"modified");
            return this.self();
        }

        public EmailAccount build() {
            return new EmailAccount(this.account, this.quota, this.antispamLevel, new GleSYSBoolean(this.antiVirus), new GleSYSBoolean(this.autoRespond), this.autoRespondMessage, new GleSYSBoolean(this.autoRespondSaveEmail), this.created, this.modified);
        }

        public T fromEmailAccount(EmailAccount in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.account(in.getAccount())).quota(in.getQuota())).antispamLevel(in.getAntispamLevel())).antiVirus(in.isAntiVirus())).autoRespond(in.isAutoRespond())).autoRespondMessage(in.getAutoRespondMessage())).autoRespondSaveEmail(in.isAutoRespondSaveEmail())).created(in.getCreated())).modified(in.getModified());
        }
    }
}

