/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.glesys.domain.ResourceUsageInfo;
import org.jclouds.glesys.domain.ResourceUsageValue;

public class ResourceUsage {
    private final ResourceUsageInfo info;
    private final Set<ResourceUsageValue> values;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResourceUsages(this);
    }

    @ConstructorProperties(value={"info", "values"})
    protected ResourceUsage(ResourceUsageInfo info, Set<ResourceUsageValue> values) {
        this.info = (ResourceUsageInfo)Preconditions.checkNotNull((Object)info, (Object)"info");
        this.values = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(values, (Object)"values")));
    }

    public ResourceUsageInfo getInfo() {
        return this.info;
    }

    public Set<ResourceUsageValue> getValues() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.info, this.values});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceUsage that = (ResourceUsage)ResourceUsage.class.cast(obj);
        return Objects.equal((Object)this.info, (Object)that.info) && Objects.equal(this.values, that.values);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("info", (Object)this.info).add("values", this.values);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected ResourceUsageInfo info;
        protected Set<ResourceUsageValue> values = ImmutableSet.of();

        protected abstract T self();

        public T info(ResourceUsageInfo info) {
            this.info = (ResourceUsageInfo)Preconditions.checkNotNull((Object)info, (Object)"info");
            return this.self();
        }

        public T values(Set<ResourceUsageValue> values) {
            this.values = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(values, (Object)"values")));
            return this.self();
        }

        public T values(ResourceUsageValue ... in) {
            return this.values((Set<ResourceUsageValue>)ImmutableSet.copyOf((Object[])in));
        }

        public ResourceUsage build() {
            return new ResourceUsage(this.info, this.values);
        }

        public T fromResourceUsages(ResourceUsage in) {
            return ((Builder)this.info(in.getInfo())).values(in.getValues());
        }
    }
}

