/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;

public class ServerLimit {
    private final long held;
    private final long maxHeld;
    private final long barrier;
    private final long limit;
    private final long failCount;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerLimit(this);
    }

    @ConstructorProperties(value={"held", "maxHeld", "barrier", "limit", "failCount"})
    protected ServerLimit(long held, long maxHeld, long barrier, long limit, long failCount) {
        this.held = held;
        this.maxHeld = maxHeld;
        this.barrier = barrier;
        this.limit = limit;
        this.failCount = failCount;
    }

    public long getHeld() {
        return this.held;
    }

    public long getMaxHeld() {
        return this.maxHeld;
    }

    public long getBarrier() {
        return this.barrier;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getFailCount() {
        return this.failCount;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.held, this.maxHeld, this.barrier, this.limit, this.failCount});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerLimit that = (ServerLimit)ServerLimit.class.cast(obj);
        return Objects.equal((Object)this.held, (Object)that.held) && Objects.equal((Object)this.maxHeld, (Object)that.maxHeld) && Objects.equal((Object)this.barrier, (Object)that.barrier) && Objects.equal((Object)this.limit, (Object)that.limit) && Objects.equal((Object)this.failCount, (Object)that.failCount);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("held", this.held).add("maxHeld", this.maxHeld).add("barrier", this.barrier).add("limit", this.limit).add("failCount", this.failCount);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long held;
        protected long maxHeld;
        protected long barrier;
        protected long limit;
        protected long failCount;

        protected abstract T self();

        public T held(long held) {
            this.held = held;
            return this.self();
        }

        public T maxHeld(long maxHeld) {
            this.maxHeld = maxHeld;
            return this.self();
        }

        public T barrier(long barrier) {
            this.barrier = barrier;
            return this.self();
        }

        public T limit(long limit) {
            this.limit = limit;
            return this.self();
        }

        public T failCount(long failCount) {
            this.failCount = failCount;
            return this.self();
        }

        public ServerLimit build() {
            return new ServerLimit(this.held, this.maxHeld, this.barrier, this.limit, this.failCount);
        }

        public T fromServerLimit(ServerLimit in) {
            return ((Builder)((Builder)((Builder)((Builder)this.held(in.getHeld())).maxHeld(in.getMaxHeld())).barrier(in.getBarrier())).limit(in.getLimit())).failCount(in.getFailCount());
        }
    }
}

