/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class ServerUptime {
    private final long current;
    private final String unit;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerUptime(this);
    }

    @ConstructorProperties(value={"current", "unit"})
    protected ServerUptime(long current, String unit) {
        this.current = current;
        this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
    }

    public long getCurrent() {
        return this.current;
    }

    public String getUnit() {
        return this.unit;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.current, this.unit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerUptime that = (ServerUptime)ServerUptime.class.cast(obj);
        return Objects.equal((Object)this.current, (Object)that.current) && Objects.equal((Object)this.unit, (Object)that.unit);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("current", this.current).add("unit", (Object)this.unit);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long current;
        protected String unit;

        protected abstract T self();

        public T current(long current) {
            this.current = current;
            return this.self();
        }

        public T unit(String unit) {
            this.unit = (String)Preconditions.checkNotNull((Object)unit, (Object)"unit");
            return this.self();
        }

        public ServerUptime build() {
            return new ServerUptime(this.current, this.unit);
        }

        public T fromServerUptime(ServerUptime in) {
            return ((Builder)this.current(in.getCurrent())).unit(in.getUnit());
        }
    }
}

