/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GoGridComputeServiceLiveTest")
public class GoGridComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public GoGridComputeServiceLiveTest() {
        this.provider = "gogrid";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (node.getUserMetadata().equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }

    protected void checkResponseEqualsHostname(ExecResponse execResponse, NodeMetadata node1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResizeRam() throws Exception {
        String group = this.group + "ram";
        GoGridClient api = (GoGridClient)((ComputeServiceContext)this.view).utils().injector().getInstance(GoGridClient.class);
        try {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
        catch (Exception e) {
            // empty catch block
        }
        Predicate serverLatestJobCompleted = Predicates2.retry((Predicate)new ServerLatestJobCompleted(api.getJobServices()), (long)800L, (long)20L, (TimeUnit)TimeUnit.SECONDS);
        String ram = ((Option)Iterables.get((Iterable)api.getServerServices().getRamSizes(), (int)1)).getName();
        try {
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.client.createNodesInGroup(group, 1));
            Server updatedServer = api.getServerServices().editServerRam(Long.valueOf(node.getId()).longValue(), ram);
            Assert.assertNotNull((Object)updatedServer);
            assert (serverLatestJobCompleted.apply((Object)updatedServer));
            Assert.assertEquals((String)((Server)Iterables.getLast((Iterable)api.getServerServices().getServersById(new long[]{Long.valueOf(node.getId())}))).getRam().getName(), (String)ram);
        }
        finally {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }
}

