/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Singleton;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.LoadBalancer;
import org.jclouds.gogrid.domain.LoadBalancerOs;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerState;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.functions.ParseLoadBalancerListFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseLoadBalancersFromJsonResponseTest")
public class ParseLoadBalancersFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.LongDateAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        public Map<Type, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(LoadBalancerOs.class, new CustomDeserializers.LoadBalancerOsAdapter());
            bindings.put(LoadBalancerState.class, new CustomDeserializers.LoadBalancerStateAdapter());
            bindings.put(LoadBalancerPersistenceType.class, new CustomDeserializers.LoadBalancerPersistenceTypeAdapter());
            bindings.put(LoadBalancerType.class, new CustomDeserializers.LoadBalancerTypeAdapter());
            bindings.put(IpState.class, new CustomDeserializers.IpStateAdapter());
            return bindings;
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_get_load_balancer_list.json");
        ParseLoadBalancerListFromJsonResponse parser = (ParseLoadBalancerListFromJsonResponse)this.i.getInstance(ParseLoadBalancerListFromJsonResponse.class);
        SortedSet response = parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        Option dc = Option.createWithIdNameAndDescription((Long)1L, (String)"US-West-1", (String)"US West 1 Datacenter");
        LoadBalancer loadBalancer = LoadBalancer.builder().id(6372L).name("Balancer").virtualIp(IpPortPair.builder().ip(Ip.builder().id(1313082L).ip("204.51.240.181").subnet("204.51.240.176/255.255.255.240").isPublic(true).state(IpState.ASSIGNED).datacenter(dc).build()).port(80).build()).realIpList(new IpPortPair[]{IpPortPair.builder().ip(Ip.builder().id(1313086L).ip("204.51.240.185").subnet("204.51.240.176/255.255.255.240").isPublic(true).state(IpState.ASSIGNED).datacenter(dc).build()).port(80).build(), IpPortPair.builder().ip(Ip.builder().id(1313089L).ip("204.51.240.188").subnet("204.51.240.176/255.255.255.240").isPublic(true).state(IpState.ASSIGNED).datacenter(dc).build()).port(80).build()}).type(LoadBalancerType.ROUND_ROBIN).persistence(LoadBalancerPersistenceType.NONE).os(LoadBalancerOs.F5).state(LoadBalancerState.ON).datacenter(dc).build();
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)response), (Object)loadBalancer);
    }
}

