/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AddServerOptionsTest")
public class AddServerOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(AddServerOptions.class));
        assert (!String.class.isAssignableFrom(AddServerOptions.class));
    }

    @Test
    public void testWithDescription() {
        AddServerOptions options = new AddServerOptions();
        options.withDescription("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWith501LengthDescription() {
        AddServerOptions options = new AddServerOptions();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 501; ++i) {
            builder.append('a');
        }
        String description = builder.toString();
        options.withDescription(description);
    }

    @Test
    public void testWith500LengthDescription() {
        AddServerOptions options = new AddServerOptions();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 500; ++i) {
            builder.append('a');
        }
        String description = builder.toString();
        options.withDescription(description);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of((Object)description));
    }

    @Test
    public void testNullWithDescription() {
        AddServerOptions options = new AddServerOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDescriptionStatic() {
        AddServerOptions options = AddServerOptions.Builder.withDescription((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDescriptionNPE() {
        AddServerOptions.Builder.withDescription(null);
    }

    @Test
    public void testAsSandboxType() {
        AddServerOptions options = new AddServerOptions();
        options.asSandboxType();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isSandbox"), (Collection)ImmutableList.of((Object)"true"));
    }

    @Test
    public void testAsSandboxTypeStatic() {
        AddServerOptions options = AddServerOptions.Builder.asSandboxType();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"isSandbox"), (Collection)ImmutableList.of((Object)"true"));
    }
}

