/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.SaveImageOptions;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.gogrid.services.BaseGoGridClientLiveTest;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GridImageClientLiveTest")
public class GridImageClientLiveTest
extends BaseGoGridClientLiveTest {
    public void testListImages() throws Exception {
        Set response = ((GoGridClient)this.api).getImageServices().getImageList(new GetImageListOptions[0]);
        assert (null != response);
        for (ServerImage image : response) {
            assert (image.getId() >= 0L) : image;
            this.checkImage(image);
            ServerImage query = (ServerImage)Iterables.getOnlyElement((Iterable)((GoGridClient)this.api).getImageServices().getImagesById(new Long[]{image.getId()}));
            Assert.assertEquals((long)query.getId(), (long)image.getId());
            this.checkImage(query);
        }
    }

    private void checkImage(ServerImage image) {
        assert (image.getArchitecture() != null) : image;
        assert (image.getBillingTokens() != null) : image;
        if (image.getCreatedTime() == null) {
            Logger.getAnonymousLogger().warning("image " + image.getId() + " is missing the createdTime field");
        }
        assert (image.getDescription() != null) : image;
        assert (image.getFriendlyName() != null) : image;
        assert (image.getId() >= 0L) : image;
        assert (image.getLocation() != null) : image;
        assert (image.getName() != null) : image;
        assert (image.getOs() != null) : image;
        assert (image.getOwner() != null) : image;
        assert (image.getPrice() >= 0.0) : image;
        assert (image.getState() != null) : image;
        assert (image.getType() != null) : image;
        if (image.getUpdatedTime() == null) {
            Logger.getAnonymousLogger().warning("image " + image.getId() + " is missing the updatedTime field");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveServerToImage() throws IOException {
        Predicate serverLatestJobCompleted = Predicates2.retry((Predicate)new ServerLatestJobCompleted(((GoGridClient)this.api).getJobServices()), (long)800L, (long)20L, (TimeUnit)TimeUnit.SECONDS);
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        ServerImage image = null;
        try {
            Set availableIps = ((GoGridClient)this.api).getIpServices().getUnassignedPublicIpList();
            Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
            Server createdServer = ((GoGridClient)this.api).getServerServices().addServer(nameOfServer, "5489", "1", availableIp.getIp(), new AddServerOptions[0]);
            Assert.assertNotNull((Object)createdServer);
            assert (serverLatestJobCompleted.apply((Object)createdServer));
            image = ((GoGridClient)this.api).getImageServices().saveImageFromServer("friendlyName", createdServer.getName(), new SaveImageOptions[]{SaveImageOptions.Builder.withDescription((String)"description")});
            Assert.assertEquals((String)image.getFriendlyName(), (String)"friendlyName");
            Assert.assertEquals((String)image.getDescription(), (String)"description");
            Assert.assertFalse((boolean)image.isPublic());
            this.assertEventuallyImageStateEquals(image, ServerImageState.AVAILABLE);
            ((GoGridClient)this.api).getImageServices().deleteById(image.getId());
            this.assertEventuallyImageStateEquals(image, ServerImageState.TRASH);
            image = null;
        }
        finally {
            if (image != null) {
                try {
                    ((GoGridClient)this.api).getImageServices().deleteById(image.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ((GoGridClient)this.api).getServerServices().deleteByName(nameOfServer);
        }
    }

    protected void assertEventuallyImageStateEquals(ServerImage image, final ServerImageState state) {
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<ServerImage>(){

            public boolean apply(ServerImage input) {
                return ((ServerImage)Iterables.getOnlyElement((Iterable)((GoGridClient)GridImageClientLiveTest.this.api).getImageServices().getImagesById(new Long[]{input.getId()}))).getState() == state;
            }
        }, (long)600L, (long)1L, (TimeUnit)TimeUnit.SECONDS).apply((Object)image));
    }
}

