/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.gogrid.services.BaseGoGridClientLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GridJobClientLiveTest")
public class GridJobClientLiveTest
extends BaseGoGridClientLiveTest {
    public void testListJobs() throws Exception {
        Set response = ((GoGridClient)this.api).getJobServices().getJobList(new GetJobListOptions[]{GetJobListOptions.Builder.maxItems((int)10)});
        assert (null != response);
        assert (response.size() <= 10) : response;
        for (Job job : response) {
            assert (job.getId() >= 0L) : job;
            this.checkJob(job);
            Job query = (Job)Iterables.getOnlyElement((Iterable)((GoGridClient)this.api).getJobServices().getJobsById(new long[]{job.getId()}));
            Assert.assertEquals((long)query.getId(), (long)job.getId());
            this.checkJob(query);
        }
    }

    private void checkJob(Job job) {
        assert (job.getAttempts() >= 0) : job;
        assert (job.getCommand() != null) : job;
        assert (job.getCreatedOn() != null) : job;
        assert (job.getCreatedOn() != null) : job;
        assert (job.getDetails() != null) : job;
        assert (job.getHistory() != null) : job;
        assert (job.getId() >= 0L) : job;
        assert (job.getLastUpdatedOn() != null) : job;
        assert (job.getObjectType() != null) : job;
        assert (job.getOwner() != null) : job;
    }
}

