/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import java.net.URI;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetServerListOptions;
import org.jclouds.gogrid.parse.ParseServerListTest;
import org.jclouds.gogrid.parse.ParseServerTest;
import org.jclouds.gogrid.services.BaseGoGridRestClientExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GridServerClientExpectTest")
public class GridServerClientExpectTest
extends BaseGoGridRestClientExpectTest {
    HttpRequest addServer = HttpRequest.builder().method("GET").endpoint("https://api.gogrid.com/api/grid/server/add").addQueryParam("v", new String[]{"1.6"}).addQueryParam("name", new String[]{"serverName"}).addQueryParam("image", new String[]{"img55"}).addQueryParam("server.ram", new String[]{"memory"}).addQueryParam("ip", new String[]{"127.0.0.1"}).addQueryParam("sig", new String[]{"e9aafd0a5d4c69bb24536be4bce8a528"}).addQueryParam("api_key", new String[]{"identity"}).build();
    HttpRequest addServerOptions = HttpRequest.builder().method("GET").endpoint("https://api.gogrid.com/api/grid/server/add").addQueryParam("v", new String[]{"1.6"}).addQueryParam("name", new String[]{"serverName"}).addQueryParam("image", new String[]{"img55"}).addQueryParam("server.ram", new String[]{"memory"}).addQueryParam("ip", new String[]{"127.0.0.1"}).addQueryParam("isSandbox", new String[]{"true"}).addQueryParam("description", new String[]{"fooy"}).addQueryParam("sig", new String[]{"e9aafd0a5d4c69bb24536be4bce8a528"}).addQueryParam("api_key", new String[]{"identity"}).build();

    public void testAddServerWhenResponseIs2xx() throws Exception {
        HttpResponse listGridServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/test_get_server_list.json", "application/json"))).build();
        GoGridClient addServerWorked = (GoGridClient)this.requestSendsResponse(this.addServer, listGridServersResponse);
        Assert.assertEquals((String)addServerWorked.getServerServices().addServer("serverName", "img55", "memory", "127.0.0.1", new AddServerOptions[0]).toString(), (String)new ParseServerTest().expected().toString());
    }

    public void testAddServerWithOptionsWhenResponseIs2xx() throws Exception {
        HttpResponse listGridServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/test_get_server_list.json", "application/json"))).build();
        GoGridClient addServerWithOptionsWorked = (GoGridClient)this.requestSendsResponse(this.addServerOptions, listGridServersResponse);
        Assert.assertEquals((String)addServerWithOptionsWorked.getServerServices().addServer("serverName", "img55", "memory", "127.0.0.1", new AddServerOptions[]{new AddServerOptions().asSandboxType().withDescription("fooy")}).toString(), (String)new ParseServerTest().expected().toString());
    }

    public void testGetServerListWhenResponseIs2xx() throws Exception {
        HttpRequest listGridServers = HttpRequest.builder().method("GET").endpoint(URI.create("https://api.gogrid.com/api/grid/server/list?v=1.6&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity")).build();
        HttpResponse listGridServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/test_get_server_list.json", "application/json"))).build();
        GoGridClient clientWhenGridServersExist = (GoGridClient)this.requestSendsResponse(listGridServers, listGridServersResponse);
        Assert.assertEquals((String)clientWhenGridServersExist.getServerServices().getServerList(new GetServerListOptions[0]).toString(), (String)new ParseServerListTest().expected().toString());
    }

    public void testGetServerListWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest listGridServers = HttpRequest.builder().method("GET").endpoint(URI.create("https://api.gogrid.com/api/grid/server/list?v=1.6&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity")).build();
        HttpResponse listGridServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/test_error_handler.json", "application/json"))).build();
        GoGridClient clientWhenNoGridServersExist = (GoGridClient)this.requestSendsResponse(listGridServers, listGridServersResponse);
        Assert.assertTrue((boolean)clientWhenNoGridServersExist.getServerServices().getServerList(new GetServerListOptions[0]).isEmpty());
    }

    public void testGetServerListWithOptionsWhenResponseIs2xx() throws Exception {
        HttpRequest listGridServers = HttpRequest.builder().method("GET").endpoint(URI.create("https://api.gogrid.com/api/grid/server/list?v=1.6&isSandbox=true&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity")).build();
        HttpResponse listGridServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/test_get_server_list.json", "application/json"))).build();
        GoGridClient clientWhenGridServersExist = (GoGridClient)this.requestSendsResponse(listGridServers, listGridServersResponse);
        Assert.assertEquals((String)clientWhenGridServersExist.getServerServices().getServerList(new GetServerListOptions[]{new GetServerListOptions.Builder().onlySandboxServers()}).toString(), (String)new ParseServerListTest().expected().toString());
    }

    public void testGetServerCredentialsWhenNotFoundThrowsResourceNotFoundExceptionWithNiceMessage() throws Exception {
        HttpRequest listGridServers = HttpRequest.builder().method("GET").endpoint(URI.create("https://api.gogrid.com/api/support/grid/password/get?v=1.6&id=11&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity")).build();
        HttpResponse listGridServersResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload(this.payloadFromResourceWithContentType("/test_error_handler.json", "application/json"))).build();
        GoGridClient clientWhenGridServersNotFound = (GoGridClient)this.requestSendsResponse(listGridServers, listGridServersResponse);
        try {
            clientWhenGridServersNotFound.getServerServices().getServerCredentials(11L);
            Assert.fail((String)"should have failed");
        }
        catch (ResourceNotFoundException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"No object found that matches your input criteria.");
        }
    }
}

