/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.gogrid.services.GridJobClient;
import org.jclouds.logging.Logger;

@Singleton
public class ServerLatestJobCompleted
implements Predicate<Server> {
    protected GridJobClient jobClient;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public ServerLatestJobCompleted(GridJobClient jobClient) {
        this.jobClient = jobClient;
    }

    public boolean apply(Server server) {
        Preconditions.checkNotNull((Object)server, (Object)"Server must be a valid instance");
        Preconditions.checkNotNull((Object)server.getName(), (Object)"Server must be a valid name");
        Job latestJob = (Job)Iterables.getOnlyElement(this.jobClient.getJobList(GetJobListOptions.Builder.latestJobForObjectByName(server.getName())));
        return JobState.SUCCEEDED.equals((Object)latestJob.getCurrentState());
    }
}

