
package org.jclouds.googlecloudstorage.domain;

import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.jclouds.javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Bucket extends Bucket {

  private final String id;
  private final String name;
  private final Long projectNumber;
  private final Date timeCreated;
  private final Long metageneration;
  private final List<BucketAccessControls> acl;
  private final List<ObjectAccessControls> defaultObjectAcl;
  private final Owner owner;
  private final DomainResourceReferences.Location location;
  private final Bucket.Website website;
  private final Bucket.Logging logging;
  private final Bucket.Versioning versioning;
  private final List<Bucket.Cors> cors;
  private final Bucket.LifeCycle lifeCycle;
  private final DomainResourceReferences.StorageClass storageClass;

  AutoValue_Bucket(
      String id,
      String name,
      @Nullable Long projectNumber,
      Date timeCreated,
      Long metageneration,
      List<BucketAccessControls> acl,
      List<ObjectAccessControls> defaultObjectAcl,
      @Nullable Owner owner,
      @Nullable DomainResourceReferences.Location location,
      @Nullable Bucket.Website website,
      @Nullable Bucket.Logging logging,
      @Nullable Bucket.Versioning versioning,
      List<Bucket.Cors> cors,
      @Nullable Bucket.LifeCycle lifeCycle,
      @Nullable DomainResourceReferences.StorageClass storageClass) {
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    this.projectNumber = projectNumber;
    if (timeCreated == null) {
      throw new NullPointerException("Null timeCreated");
    }
    this.timeCreated = timeCreated;
    if (metageneration == null) {
      throw new NullPointerException("Null metageneration");
    }
    this.metageneration = metageneration;
    if (acl == null) {
      throw new NullPointerException("Null acl");
    }
    this.acl = acl;
    if (defaultObjectAcl == null) {
      throw new NullPointerException("Null defaultObjectAcl");
    }
    this.defaultObjectAcl = defaultObjectAcl;
    this.owner = owner;
    this.location = location;
    this.website = website;
    this.logging = logging;
    this.versioning = versioning;
    if (cors == null) {
      throw new NullPointerException("Null cors");
    }
    this.cors = cors;
    this.lifeCycle = lifeCycle;
    this.storageClass = storageClass;
  }

  @Override
  public String id() {
    return id;
  }

  @Override
  public String name() {
    return name;
  }

  @Nullable
  @Override
  public Long projectNumber() {
    return projectNumber;
  }

  @Override
  public Date timeCreated() {
    return timeCreated;
  }

  @Override
  public Long metageneration() {
    return metageneration;
  }

  @Override
  public List<BucketAccessControls> acl() {
    return acl;
  }

  @Override
  public List<ObjectAccessControls> defaultObjectAcl() {
    return defaultObjectAcl;
  }

  @Nullable
  @Override
  public Owner owner() {
    return owner;
  }

  @Nullable
  @Override
  public DomainResourceReferences.Location location() {
    return location;
  }

  @Nullable
  @Override
  public Bucket.Website website() {
    return website;
  }

  @Nullable
  @Override
  public Bucket.Logging logging() {
    return logging;
  }

  @Nullable
  @Override
  public Bucket.Versioning versioning() {
    return versioning;
  }

  @Override
  public List<Bucket.Cors> cors() {
    return cors;
  }

  @Nullable
  @Override
  public Bucket.LifeCycle lifeCycle() {
    return lifeCycle;
  }

  @Nullable
  @Override
  public DomainResourceReferences.StorageClass storageClass() {
    return storageClass;
  }

  @Override
  public String toString() {
    return "Bucket{"
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "projectNumber=" + projectNumber + ", "
        + "timeCreated=" + timeCreated + ", "
        + "metageneration=" + metageneration + ", "
        + "acl=" + acl + ", "
        + "defaultObjectAcl=" + defaultObjectAcl + ", "
        + "owner=" + owner + ", "
        + "location=" + location + ", "
        + "website=" + website + ", "
        + "logging=" + logging + ", "
        + "versioning=" + versioning + ", "
        + "cors=" + cors + ", "
        + "lifeCycle=" + lifeCycle + ", "
        + "storageClass=" + storageClass
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Bucket) {
      Bucket that = (Bucket) o;
      return (this.id.equals(that.id()))
           && (this.name.equals(that.name()))
           && ((this.projectNumber == null) ? (that.projectNumber() == null) : this.projectNumber.equals(that.projectNumber()))
           && (this.timeCreated.equals(that.timeCreated()))
           && (this.metageneration.equals(that.metageneration()))
           && (this.acl.equals(that.acl()))
           && (this.defaultObjectAcl.equals(that.defaultObjectAcl()))
           && ((this.owner == null) ? (that.owner() == null) : this.owner.equals(that.owner()))
           && ((this.location == null) ? (that.location() == null) : this.location.equals(that.location()))
           && ((this.website == null) ? (that.website() == null) : this.website.equals(that.website()))
           && ((this.logging == null) ? (that.logging() == null) : this.logging.equals(that.logging()))
           && ((this.versioning == null) ? (that.versioning() == null) : this.versioning.equals(that.versioning()))
           && (this.cors.equals(that.cors()))
           && ((this.lifeCycle == null) ? (that.lifeCycle() == null) : this.lifeCycle.equals(that.lifeCycle()))
           && ((this.storageClass == null) ? (that.storageClass() == null) : this.storageClass.equals(that.storageClass()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.id.hashCode();
    h *= 1000003;
    h ^= this.name.hashCode();
    h *= 1000003;
    h ^= (projectNumber == null) ? 0 : this.projectNumber.hashCode();
    h *= 1000003;
    h ^= this.timeCreated.hashCode();
    h *= 1000003;
    h ^= this.metageneration.hashCode();
    h *= 1000003;
    h ^= this.acl.hashCode();
    h *= 1000003;
    h ^= this.defaultObjectAcl.hashCode();
    h *= 1000003;
    h ^= (owner == null) ? 0 : this.owner.hashCode();
    h *= 1000003;
    h ^= (location == null) ? 0 : this.location.hashCode();
    h *= 1000003;
    h ^= (website == null) ? 0 : this.website.hashCode();
    h *= 1000003;
    h ^= (logging == null) ? 0 : this.logging.hashCode();
    h *= 1000003;
    h ^= (versioning == null) ? 0 : this.versioning.hashCode();
    h *= 1000003;
    h ^= this.cors.hashCode();
    h *= 1000003;
    h ^= (lifeCycle == null) ? 0 : this.lifeCycle.hashCode();
    h *= 1000003;
    h ^= (storageClass == null) ? 0 : this.storageClass.hashCode();
    return h;
  }

}
