/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.internal;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.util.Strings2;

public enum KeystoneFixture {
    INSTANCE;


    public String getTenantName() {
        return "12346637803162";
    }

    public HttpRequest initialAuthWithUsernameAndPassword(String username, String password) {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/tokens").addHeader("Accept", new String[]{"application/json"})).payload(BaseRestApiExpectTest.payloadFromStringWithContentType((String)String.format("{\"auth\":{\"passwordCredentials\":{\"username\":\"%s\",\"password\":\"%s\"},\"tenantName\":\"%s\"}}", username, password, this.getTenantName()), (String)"application/json"))).build();
    }

    public HttpRequest initialAuthWithAccessKeyAndSecretKey(String accessKey, String secretKey) {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/tokens").addHeader("Accept", new String[]{"application/json"})).payload(BaseRestApiExpectTest.payloadFromStringWithContentType((String)String.format("{\"auth\":{\"apiAccessKeyCredentials\":{\"accessKey\":\"%s\",\"secretKey\":\"%s\"},\"tenantName\":\"%s\"}}", accessKey, secretKey, this.getTenantName()), (String)"application/json"))).build();
    }

    public String getAuthToken() {
        return "Auth_4f173437e4b013bee56d1007";
    }

    public HttpResponse responseWithAccess() {
        return ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200").payload(this.payloadFromResourceWithContentType("/keystoneAuthResponse.json", "application/json"))).build();
    }

    public Payload payloadFromResourceWithContentType(String resource, String contentType) {
        try {
            return BaseRestApiExpectTest.payloadFromStringWithContentType((String)Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resource)), (String)contentType);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

