/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Properties;
import java.util.Random;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.softlayer.SoftLayerClient;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.compute.strategy.SoftLayerComputeServiceAdapter;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.features.BaseSoftLayerClientLiveTest;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="SoftLayerComputeServiceAdapterLiveTest")
public class SoftLayerComputeServiceAdapterLiveTest
extends BaseSoftLayerClientLiveTest {
    private SoftLayerComputeServiceAdapter adapter;
    private TemplateBuilder templateBuilder;
    private SshClient.Factory sshFactory;
    private ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest> guest;
    private static final PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate = new PrioritizeCredentialsFromTemplate((Function)new DefaultCredentialsFromImageOrOverridingCredentials());

    protected SoftLayerClient create(Properties props, Iterable<Module> modules) {
        Injector injector = this.newBuilder().modules(modules).overrides(props).buildInjector();
        this.adapter = (SoftLayerComputeServiceAdapter)injector.getInstance(SoftLayerComputeServiceAdapter.class);
        this.templateBuilder = (TemplateBuilder)injector.getInstance(TemplateBuilder.class);
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        return (SoftLayerClient)injector.getInstance(SoftLayerClient.class);
    }

    @Test
    public void testListLocations() {
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)this.adapter.listLocations()), (String)"locations must not be empty");
    }

    @Test
    public void testCreateNodeWithGroupEncodedIntoNameThenStoreCredentials() {
        String group = "foo";
        String name = "node" + new Random().nextInt();
        Template template = this.templateBuilder.build();
        ((SoftLayerTemplateOptions)template.getOptions().as(SoftLayerTemplateOptions.class)).domainName("me.org");
        this.guest = this.adapter.createNodeWithGroupEncodedIntoName(group, name, template);
        Assert.assertEquals((String)((VirtualGuest)this.guest.getNode()).getHostname(), (String)name);
        Assert.assertEquals((String)this.guest.getNodeId(), (String)(((VirtualGuest)this.guest.getNode()).getId() + ""));
        Assert.assertEquals((String)((VirtualGuest)this.guest.getNode()).getDomain(), (String)((SoftLayerTemplateOptions)template.getOptions().as(SoftLayerTemplateOptions.class)).getDomainName());
        assert (InetAddresses.isInetAddress((String)((VirtualGuest)this.guest.getNode()).getPrimaryBackendIpAddress())) : this.guest;
        this.doConnectViaSsh((VirtualGuest)this.guest.getNode(), prioritizeCredentialsFromTemplate.apply(template, this.guest.getCredentials()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnectViaSsh(VirtualGuest guest, LoginCredentials creds) {
        SshClient ssh = this.sshFactory.create(HostAndPort.fromParts((String)guest.getPrimaryIpAddress(), (int)22), creds);
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
            System.err.println(ssh.exec("df -k").getOutput());
            System.err.println(ssh.exec("mount").getOutput());
            System.err.println(ssh.exec("uname -a").getOutput());
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @Test
    public void testListHardwareProfiles() {
        Iterable profiles = this.adapter.listHardwareProfiles();
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)profiles));
        for (Iterable profile : profiles) {
            Assert.assertEquals((int)Iterables.size((Iterable)profile), (int)3);
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.guest != null) {
            this.adapter.destroyNode(this.guest.getNodeId() + "");
        }
        super.tearDown();
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)new SshjSshClientModule());
    }

    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("jclouds.ssh.max-retries", "10");
        return properties;
    }
}

