/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true)
public class SoftLayerComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public SoftLayerComputeServiceLiveTest() {
        this.provider = "softlayer";
        this.group = "soft-layer";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (node.getUserMetadata().equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }

    public void testOptionToNotBlock() {
    }

    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("jclouds.ssh.max-retries", "20");
        return properties;
    }
}

