/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class SoftLayerTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public static final int MAX_RAM = 49152;

    public SoftLayerTemplateBuilderLiveTest() {
        this.provider = "softlayer";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return input.version.equals("") || input.version.equals("10.04") || input.version.equals("12.04") || input.version.equals("8");
                    }
                    case DEBIAN: {
                        return input.version.equals("") || input.version.matches("[56].0");
                    }
                    case FEDORA: {
                        return input.version.equals("") || input.version.equals("13") || input.version.equals("15");
                    }
                    case RHEL: {
                        return input.version.equals("") || input.version.equals("5") || input.version.equals("6");
                    }
                    case CENTOS: {
                        return input.version.equals("") || input.version.equals("5") || input.version.equals("6.0");
                    }
                    case WINDOWS: {
                        return input.version.equals("") || input.version.equals("2003") || input.version.equals("2008");
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"12.04");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
        Assert.assertEquals((int)defaultTemplate.getHardware().getRam(), (int)1024);
        Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)defaultTemplate.getHardware()), (Object)25.0);
        Assert.assertEquals((Object)((Volume)defaultTemplate.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.LOCAL);
        Assert.assertEquals(defaultTemplate.getOptions().getClass(), SoftLayerTemplateOptions.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderFindsGigabitUplink() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.softlayer.virtualguest.port-speed", "1000");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            context.getComputeService().templateBuilder().build();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemplateBuilderFindsMegabitUplink() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.softlayer.virtualguest.port-speed", "100");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            context.getComputeService().templateBuilder().build();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBiggestTemplateBuilderWhenBootIsSAN() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.softlayer.virtualguest.disk0-type", "SAN");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Template template = context.getComputeService().templateBuilder().biggest().build();
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)16.0);
            Assert.assertEquals((int)template.getHardware().getRam(), (int)49152);
            Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)template.getHardware()), (Object)100.0);
            Assert.assertEquals((Object)((Volume)template.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.SAN);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultTemplateBuilderWhenPrivateNetwork() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.softlayer.virtualguest.cpu-regex", "Private [0-9]+ x ([.0-9]+) GHz Core[s]?");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Template template = context.getComputeService().templateBuilder().build();
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)1.0);
            Assert.assertEquals((int)template.getHardware().getRam(), (int)1024);
            Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)template.getHardware()), (Object)25.0);
            Assert.assertEquals((Object)((Volume)template.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.LOCAL);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBiggestTemplateBuilderWhenPrivateNetwork() throws IOException {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty("jclouds.softlayer.virtualguest.cpu-regex", "Private [0-9]+ x ([.0-9]+) GHz Core[s]?");
            context = (ComputeServiceContext)this.createView(overrides, this.setupModules());
            Template template = context.getComputeService().templateBuilder().biggest().build();
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)8.0);
            Assert.assertEquals((int)template.getHardware().getRam(), (int)49152);
            Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)template.getHardware()), (Object)100.0);
            Assert.assertEquals((Object)((Volume)template.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.LOCAL);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    public void testFastestTemplateBuilder() throws IOException {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().fastest().build();
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)16.0);
        Assert.assertEquals((int)template.getHardware().getRam(), (int)1024);
        Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)template.getHardware()), (Object)25.0);
        Assert.assertEquals((Object)((Volume)template.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.LOCAL);
    }

    @Test
    public void testBiggestTemplateBuilder() throws IOException {
        Template template = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().biggest().build();
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)template.getHardware()), (Object)16.0);
        Assert.assertEquals((int)template.getHardware().getRam(), (int)49152);
        Assert.assertEquals((Object)ComputeServiceUtils.getSpace((Hardware)template.getHardware()), (Object)100.0);
        Assert.assertEquals((Object)((Volume)template.getHardware().getVolumes().get(0)).getType(), (Object)Volume.Type.LOCAL);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"SG", (Object)"US-CA", (Object)"US-TX", (Object)"US-VA", (Object)"US-WA", (Object)"NL", (Object[])new String[]{"NSFTW-IL"});
    }
}

