/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.softlayer.compute.functions.DatacenterToLocation;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Datacenter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(singleThreaded=true, groups={"unit"})
public class DatacenterToLocationTest {
    static DatacenterToLocation function = new DatacenterToLocation(new JustProvider("softlayer", Suppliers.ofInstance((Object)URI.create("foo")), (Set)ImmutableSet.of()));

    @Test
    public void testDatacenterToLocation() {
        Address address = Address.builder().country("US").state("TX").description("This is Texas!").build();
        Datacenter datacenter = Datacenter.builder().id(1).longName("Texas Datacenter").locationAddress(address).build();
        Location location = function.apply(datacenter);
        AssertJUnit.assertEquals((String)location.getId(), (String)Long.toString(datacenter.getId()));
        Set iso3166Codes = location.getIso3166Codes();
        AssertJUnit.assertEquals((int)iso3166Codes.size(), (int)1);
        AssertJUnit.assertTrue((boolean)iso3166Codes.contains("US-TX"));
    }

    @Test
    public void testGetIso3166CodeNoCountryAndState() {
        Datacenter datacenter = Datacenter.builder().id(1).longName("Nowhere").build();
        Location location = function.apply(datacenter);
        AssertJUnit.assertEquals((String)location.getId(), (String)Long.toString(datacenter.getId()));
        Set iso3166Codes = location.getIso3166Codes();
        AssertJUnit.assertEquals((int)iso3166Codes.size(), (int)0);
    }

    @Test
    public void testGetIso3166CodeCountryOnly() {
        Address address = Address.builder().country("US").description("This is North America!").build();
        Datacenter datacenter = Datacenter.builder().id(1).longName("Nowhere").locationAddress(address).build();
        Location location = function.apply(datacenter);
        AssertJUnit.assertEquals((String)location.getId(), (String)Long.toString(datacenter.getId()));
        Set iso3166Codes = location.getIso3166Codes();
        AssertJUnit.assertEquals((int)iso3166Codes.size(), (int)1);
        AssertJUnit.assertTrue((boolean)iso3166Codes.contains("US"));
    }

    @Test
    public void testGetIso3166CodeWhitespaceTrimmer() {
        Address address = Address.builder().country(" US ").state("  TX  ").description("This is spaced out Texas").build();
        Datacenter datacenter = Datacenter.builder().id(1).longName("Nowhere").locationAddress(address).build();
        Location location = function.apply(datacenter);
        AssertJUnit.assertEquals((String)location.getId(), (String)Long.toString(datacenter.getId()));
        Set iso3166Codes = location.getIso3166Codes();
        AssertJUnit.assertEquals((int)iso3166Codes.size(), (int)1);
        AssertJUnit.assertTrue((boolean)iso3166Codes.contains("US-TX"));
    }
}

