/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.softlayer.compute.functions.ProductItemToImage;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ProductItemToImageTest")
public class ProductItemToImageTest {
    private static final List<String> operatingSystems = Arrays.asList("CentOS 5 - LAMP Install (32 bit)", "CentOS 5 - LAMP Install (64 bit)", "CentOS 5 - Minimal Install (32 bit)", "CentOS 5 - Minimal Install (64 bit)", "CentOS 6.0 - LAMP Install (32 bit)", "CentOS 6.0 - LAMP Install (64 bit)", "CentOS 6.0 - Minimal Install (32 bit)", "CentOS 6.0 - Minimal Install (64 bit)", "Debian GNU/Linux 5.0 Lenny/Stable - LAMP Install (32 bit)", "Debian GNU/Linux 5.0 Lenny/Stable - LAMP Install (64 bit)", "Debian GNU/Linux 5.0 Lenny/Stable - Minimal Install (32 bit)", "Debian GNU/Linux 5.0 Lenny/Stable - Minimal Install (64 bit)", "Fedora Release 13 (32bit) - LAMP Install", "Fedora Release 13 (32bit) - Minimal Install", "Fedora Release 13 (64bit) - LAMP Install", "Fedora Release 13 (64bit) - Minimal Install", "Fedora Release 15 (32bit) - LAMP Install", "Fedora Release 15 (32bit) - Minimal Install", "Fedora Release 15 (64bit) - LAMP Install", "Fedora Release 15 (64bit) - Minimal Install", "Red Hat Enterprise Linux 5 - LAMP Install (32 bit)", "Red Hat Enterprise Linux 5 - LAMP Install (64 bit)", "Red Hat Enterprise Linux 5 - Minimal Install (64 bit)", "Red Hat Enterprise Linux 6 - LAMP Install (32 bit)", "Red Hat Enterprise Linux 6 - LAMP Install (64 bit)", "Red Hat Enterprise Linux 6 - Minimal Install (32 bit)", "Red Hat Enterprise Linux 6 - Minimal Install (64 bit)", "Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "Ubuntu Linux 8 LTS Hardy Heron - LAMP Install (32 bit)", "Ubuntu Linux 8 LTS Hardy Heron - LAMP Install (64 bit)", "Ubuntu Linux 8 LTS Hardy Heron - Minimal Install (32 bit)", "Ubuntu Linux 8 LTS Hardy Heron - Minimal Install (64 bit)", "CloudLinux 6 (32 bit)", "CloudLinux 6 (64 bit)", "Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "Windows Server 2003 Standard SP2 with R2 (64 bit)", "Windows Server 2008 Datacenter Edition SP2 (32bit)", "Windows Server 2008 Datacenter Edition SP2 (64bit)", "Windows Server 2008 Enterprise Edition SP2 (32bit)", "Windows Server 2008 Enterprise Edition SP2 (64bit)", "Windows Server 2008 R2 Datacenter Edition (64bit)", "Windows Server 2008 R2 Enterprise Edition (64bit)", "Windows Server 2008 R2 Standard Edition (64bit)", "Windows Server 2008 Standard Edition SP2 (32bit)", "Windows Server 2008 Standard Edition SP2 (64bit)");

    @Test
    public void testConversion() {
        for (String description : operatingSystems) {
            ProductItem item = ProductItem.builder().description(description).prices(new ProductItemPrice[]{ProductItemPrice.builder().id(1234).build()}).build();
            Image i = new ProductItemToImage().apply(item);
            OperatingSystem os = i.getOperatingSystem();
            Assert.assertNotNull((Object)os);
            Assert.assertNotNull((Object)os.getFamily());
            Assert.assertFalse((boolean)os.getFamily().equals((Object)OsFamily.UNRECOGNIZED));
            Assert.assertNotNull((Object)os.getVersion());
        }
    }

    @Test
    public void testUbuntu() {
        ProductItem item = ProductItem.builder().description("Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)").prices(new ProductItemPrice[]{ProductItemPrice.builder().id(1234).build()}).build();
        Image i = new ProductItemToImage().apply(item);
        OperatingSystem os = i.getOperatingSystem();
        Assert.assertNotNull((Object)os);
        Assert.assertEquals((Object)os.getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)os.getVersion(), (String)"10.04");
        Assert.assertTrue((boolean)os.is64Bit());
    }

    @Test
    public void testUbuntuNoBitCount() {
        ProductItem item = ProductItem.builder().description("Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install").prices(new ProductItemPrice[]{ProductItemPrice.builder().id(1234).build()}).build();
        Image i = new ProductItemToImage().apply(item);
        OperatingSystem os = i.getOperatingSystem();
        Assert.assertNotNull((Object)os);
        Assert.assertEquals((Object)os.getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)os.getVersion(), (String)"10.04");
        Assert.assertFalse((boolean)os.is64Bit());
    }

    @Test
    public void testCompletelyUnknown() {
        ProductItem item = ProductItem.builder().description("This fails to match anything!!!").prices(new ProductItemPrice[]{ProductItemPrice.builder().id(1234).build()}).build();
        Image i = new ProductItemToImage().apply(item);
        OperatingSystem os = i.getOperatingSystem();
        Assert.assertNotNull((Object)os);
        Assert.assertEquals((Object)os.getFamily(), (Object)OsFamily.UNRECOGNIZED);
        Assert.assertNull((Object)os.getVersion());
        Assert.assertFalse((boolean)os.is64Bit());
    }

    @Test
    public void test64BitUnknown() {
        ProductItem item = ProductItem.builder().description("This only has the bit-count (64 bit)").prices(new ProductItemPrice[]{ProductItemPrice.builder().id(1234).build()}).build();
        Image i = new ProductItemToImage().apply(item);
        OperatingSystem os = i.getOperatingSystem();
        Assert.assertNotNull((Object)os);
        Assert.assertEquals((Object)os.getFamily(), (Object)OsFamily.UNRECOGNIZED);
        Assert.assertNull((Object)os.getVersion());
        Assert.assertTrue((boolean)os.is64Bit());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNull() {
        new ProductItemToImage().apply(null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNoDescription() {
        ProductItem item = ProductItem.builder().prices(new ProductItemPrice[]{ProductItemPrice.builder().id(1234).build()}).build();
        new ProductItemToImage().apply(item);
    }

    @Test
    public void testId() {
        ProductItemPrice price = ProductItemPrice.builder().id(1234).build();
        ProductItem item = ProductItem.builder().id(5678).prices(new ProductItemPrice[]{price}).build();
        Assert.assertEquals((String)((String)ProductItemToImage.imageId().apply((Object)item)), (String)"1234", (String)"Expected the ID of the ProductItemPrice to be returned");
    }

    @Test
    public void testIdManyPrices() {
        ProductItemPrice price1 = ProductItemPrice.builder().id(1234).build();
        ProductItemPrice price2 = ProductItemPrice.builder().id(5678).build();
        ProductItem item = ProductItem.builder().id(9012).prices((Set)ImmutableSet.of((Object)price1, (Object)price2)).build();
        Assert.assertEquals((String)((String)ProductItemToImage.imageId().apply((Object)item)), (String)"1234", (String)"Expected the ID of the ProductItemPrice to be returned");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testIdMissingPrices() {
        ProductItem item = ProductItem.builder().build();
        ProductItemToImage.imageId().apply((Object)item);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIdNull() {
        ProductItemToImage.imageId().apply(null);
    }

    @Test
    public void testOsFamily() {
        Assert.assertEquals((Object)ProductItemToImage.osFamily().apply((Object)"Ubuntu Linux os"), (Object)OsFamily.UBUNTU);
    }

    @Test
    public void testOsFamilyUnrecognized() {
        Assert.assertEquals((Object)ProductItemToImage.osFamily().apply((Object)"not a known operating system"), (Object)OsFamily.UNRECOGNIZED);
    }

    @Test
    public void testOsFamilyNull() {
        Assert.assertEquals((Object)ProductItemToImage.osFamily().apply(null), (Object)OsFamily.UNRECOGNIZED);
    }

    @Test
    public void testOsBitsWithSpace() {
        Assert.assertEquals((Object)ProductItemToImage.osBits().apply((Object)"a (32 bit) os"), (Object)32);
    }

    @Test
    public void testOsBitsNoSpace() {
        Assert.assertEquals((Object)ProductItemToImage.osBits().apply((Object)"a (64bit) os"), (Object)64);
    }

    @Test
    public void testOsBitsMissing() {
        Assert.assertNull((Object)ProductItemToImage.osBits().apply((Object)"an os"));
    }

    @Test
    public void testOsBitsNull() {
        Assert.assertNull((Object)ProductItemToImage.osBits().apply(null));
    }

    @Test
    public void testOsVersion() {
        Assert.assertEquals((String)((String)ProductItemToImage.osVersion().apply((Object)"Windows Server 2099 (256 bit)")), (String)"2099");
    }

    @Test
    public void testOsVersionMissing() {
        Assert.assertNull((Object)ProductItemToImage.osVersion().apply((Object)"asd Server"));
    }

    @Test
    public void testOsVersionNull() {
        Assert.assertNull((Object)ProductItemToImage.osVersion().apply(null));
    }
}

