/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.collect.ImmutableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.softlayer.compute.functions.ProductItems;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ProductItemsTest {
    private ProductItemCategory category;
    private ProductItemPrice price;
    private ProductItem item;

    @BeforeMethod
    public void setup() {
        this.category = ProductItemCategory.builder().id(1).categoryCode("category").build();
        this.price = ProductItemPrice.builder().id(1).build();
        this.item = ProductItem.builder().id(1).capacity(Float.valueOf(2.0f)).description("an item").prices(new ProductItemPrice[]{this.price}).build();
    }

    @Test
    public void testCapacity() {
        Assert.assertEquals((Object)ProductItems.capacity().apply((Object)this.item), (Object)Float.valueOf(2.0f));
    }

    @Test
    public void testCapacityMissing() {
        ProductItem item = ProductItem.builder().id(1).build();
        Assert.assertNull((Object)ProductItems.capacity().apply((Object)item));
    }

    @Test
    public void testDescription() {
        Assert.assertEquals((String)((String)ProductItems.description().apply((Object)this.item)), (String)"an item");
    }

    @Test
    public void testDescriptionMissing() {
        ProductItem item = ProductItem.builder().id(1).build();
        Assert.assertNull((Object)ProductItems.description().apply((Object)item));
    }

    @Test
    public void testPrice() {
        Assert.assertEquals((Object)ProductItems.price().apply((Object)this.item), (Object)this.price);
    }

    @Test
    public void testPriceMultiplePrices() {
        ImmutableSet prices = ImmutableSet.of((Object)this.price, (Object)ProductItemPrice.builder().id(2).build());
        ProductItem item2 = ProductItem.builder().prices((Set)prices).build();
        Assert.assertEquals((Object)ProductItems.price().apply((Object)item2), (Object)this.price);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testPriceMissing() {
        ProductItem noPriceItem = ProductItem.builder().id(1).build();
        ProductItems.price().apply((Object)noPriceItem);
    }

    @Test
    public void testItemCallGetsCategory() {
        ProductItemPrice price = ProductItemPrice.builder().id(1).categories(new ProductItemCategory[]{this.category}).item(this.item).build();
        ProductItem newItem = (ProductItem)ProductItems.item().apply((Object)price);
        Assert.assertEquals((Set)newItem.getCategories(), (Set)ImmutableSet.of((Object)this.category));
    }

    @Test
    public void testItemCallNoCategoryOnPrice() {
        ProductItem item1 = this.item.toBuilder().categories((Set)ImmutableSet.of((Object)this.category)).build();
        ProductItemPrice price = ProductItemPrice.builder().id(1).item(item1).build();
        ProductItem newItem = (ProductItem)ProductItems.item().apply((Object)price);
        Assert.assertEquals((Set)newItem.getCategories(), (Set)ImmutableSet.of((Object)this.category));
    }

    @Test
    public void testItemCallCategoryExists() {
        ProductItemCategory category2 = ProductItemCategory.builder().id(12).categoryCode("new category").build();
        ProductItem item1 = this.item.toBuilder().categories((Set)ImmutableSet.of((Object)category2)).build();
        ProductItemPrice price = ProductItemPrice.builder().id(1).categories(new ProductItemCategory[]{this.category}).item(item1).build();
        ProductItem newItem = (ProductItem)ProductItems.item().apply((Object)price);
        Assert.assertEquals((Set)newItem.getCategories(), (Set)ImmutableSet.of((Object)category2));
    }
}

