/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.List;
import java.util.Properties;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.softlayer.SoftLayerProviderMetadata;
import org.jclouds.softlayer.compute.functions.ProductItemsToHardware;
import org.jclouds.softlayer.domain.ProductItem;
import org.jclouds.softlayer.domain.ProductItemCategory;
import org.jclouds.softlayer.domain.ProductItemPrice;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ProductItemsToHardwareTest {
    private ProductItemsToHardware toHardware;
    private ProductItem cpuItem;
    private ProductItem ramItem;
    private ProductItem volumeItem;

    @BeforeMethod
    public void setup() {
        this.toHardware = (ProductItemsToHardware)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)new SoftLayerProviderMetadata().getDefaultProperties());
            }
        }}).getInstance(ProductItemsToHardware.class);
        this.cpuItem = ProductItem.builder().id(1).description("2 x 2.0 GHz Cores").capacity(Float.valueOf(2.0f)).categories(new ProductItemCategory[]{ProductItemCategory.builder().categoryCode("guest_core").build()}).prices(new ProductItemPrice[]{ProductItemPrice.builder().id(123).build()}).build();
        this.ramItem = ProductItem.builder().id(2).description("2GB ram").capacity(Float.valueOf(2.0f)).categories(new ProductItemCategory[]{ProductItemCategory.builder().categoryCode("ram").build()}).prices(new ProductItemPrice[]{ProductItemPrice.builder().id(456).build()}).build();
        this.volumeItem = ProductItem.builder().id(3).description("100 GB (SAN)").capacity(Float.valueOf(100.0f)).prices(new ProductItemPrice[]{ProductItemPrice.builder().id(789).build()}).categories(new ProductItemCategory[]{ProductItemCategory.builder().categoryCode("guest_disk0").build()}).build();
    }

    @Test
    public void testHardwareId() {
        ProductItem item1 = ProductItem.builder().prices(new ProductItemPrice[]{ProductItemPrice.builder().id(123).build()}).build();
        ProductItem item2 = ProductItem.builder().prices(new ProductItemPrice[]{ProductItemPrice.builder().id(456).build()}).build();
        ProductItem item3 = ProductItem.builder().prices(new ProductItemPrice[]{ProductItemPrice.builder().id(789).build()}).build();
        String id = (String)ProductItemsToHardware.hardwareId().apply((Object)ImmutableList.of((Object)item1, (Object)item2, (Object)item3));
        AssertJUnit.assertEquals((String)"123,456,789", (String)id);
    }

    @Test
    public void testHardware() {
        Hardware hardware = this.toHardware.apply((Iterable)ImmutableSet.of((Object)this.cpuItem, (Object)this.ramItem, (Object)this.volumeItem));
        AssertJUnit.assertEquals((String)"123,456,789", (String)hardware.getId());
        List processors = hardware.getProcessors();
        AssertJUnit.assertEquals((int)1, (int)processors.size());
        AssertJUnit.assertEquals((Object)2.0, (Object)((Processor)processors.get(0)).getCores());
        AssertJUnit.assertEquals((int)2048, (int)hardware.getRam());
        List volumes = hardware.getVolumes();
        AssertJUnit.assertEquals((int)1, (int)volumes.size());
        Volume volume = (Volume)volumes.get(0);
        AssertJUnit.assertEquals((Object)Float.valueOf(100.0f), (Object)volume.getSize());
        AssertJUnit.assertEquals((Object)Volume.Type.SAN, (Object)volume.getType());
        AssertJUnit.assertEquals((boolean)true, (boolean)volume.isBootDevice());
    }

    @Test
    public void testHardwareWithPrivateCore() {
        this.cpuItem = this.cpuItem.toBuilder().description("Private 2 x 2.0 GHz Cores").build();
        Hardware hardware = this.toHardware.apply((Iterable)ImmutableSet.of((Object)this.cpuItem, (Object)this.ramItem, (Object)this.volumeItem));
        AssertJUnit.assertEquals((String)"123,456,789", (String)hardware.getId());
        List processors = hardware.getProcessors();
        AssertJUnit.assertEquals((int)1, (int)processors.size());
        AssertJUnit.assertEquals((Object)2.0, (Object)((Processor)processors.get(0)).getCores());
        AssertJUnit.assertEquals((int)2048, (int)hardware.getRam());
        List volumes = hardware.getVolumes();
        AssertJUnit.assertEquals((int)1, (int)volumes.size());
        AssertJUnit.assertEquals((Object)Float.valueOf(100.0f), (Object)((Volume)volumes.get(0)).getSize());
    }

    @Test
    public void testHardwareWithTwoDisks() {
        ProductItem localVolumeItem = ProductItem.builder().id(4).description("25 GB").capacity(Float.valueOf(25.0f)).prices(new ProductItemPrice[]{ProductItemPrice.builder().id(987).build()}).categories(new ProductItemCategory[]{ProductItemCategory.builder().categoryCode("guest_disk1").build()}).build();
        Hardware hardware = this.toHardware.apply((Iterable)ImmutableSet.of((Object)this.cpuItem, (Object)this.ramItem, (Object)this.volumeItem, (Object)localVolumeItem));
        List volumes = hardware.getVolumes();
        AssertJUnit.assertEquals((int)2, (int)volumes.size());
        Volume volume = (Volume)volumes.get(0);
        AssertJUnit.assertEquals((Object)Float.valueOf(100.0f), (Object)volume.getSize());
        AssertJUnit.assertEquals((Object)Volume.Type.SAN, (Object)volume.getType());
        AssertJUnit.assertEquals((boolean)true, (boolean)volume.isBootDevice());
        Volume volume1 = (Volume)volumes.get(1);
        AssertJUnit.assertEquals((Object)Float.valueOf(25.0f), (Object)volume1.getSize());
        AssertJUnit.assertEquals((Object)Volume.Type.LOCAL, (Object)volume1.getType());
        AssertJUnit.assertEquals((boolean)false, (boolean)volume1.isBootDevice());
    }
}

